#include <string>
#include <vector>

#include "mbed.h"
#include "SDFileSystem.h"
#include "esp8266.h"
#include "stepper.h"
#include "laser.h"

Serial ser2usb(PA_9, PA_10, 115200);


//.....assumes SDFileSystem is setup in earlier code for device "/sd"


void read_file_names(char *dir, vector<string> & filenames)
{
    DIR *dp;
    struct dirent *dirp;
    dp = opendir(dir);
    //read all directory and file names in current directory into filename vector
    while((dirp = readdir(dp)) != NULL) {
        filenames.push_back(string(dirp->d_name));
    }
    closedir(dp);
}



int main()
{
    ser2usb.printf("hello\r\n");
    //....example call in your "main" code somewhere.....
    vector<string> filenames; 
    //filenames are stored in a vector string

    // read file names into vector of strings
    read_file_names("/sd", filenames);
    // print filename strings from vector using an iterator
    for(vector<string>::iterator it=filenames.begin(); it < filenames.end(); it++) {
        ser2usb.printf("%s\n\r",(*it).c_str());
    }
}