#include <string>
#include <vector>
#include "mbed.h"
#include "SDFileSystem.h"

//using namespace std;

Serial ser2usb(PA_9, PA_10, 115200);

// mosi, miso, sclk, cs, name
SDFileSystem sd(PB_15, PB_14, PB_13, PB_12, "sd");

char mydir[1024];

vector<string> filenames; //filenames are stored in a vector string
 
void read_file_names(char *dir)
//这个函数后期可以重载成带一个输入vector<string>引用对象的方法
//这样这个vector可以不用声明成全局变量
//already reload
{
    DIR *dp;//一个文件地址对象指针
    struct dirent *dirp;
    //下面是dirent的定义
    //struct dirent
    //{
    //    long d_ino;                     
    //    off_t d_off;                    
    //    unsigned short d_reclen;        
    //    char d_name [NAME_MAX+1];       
    //}
    
    /****************************************************************
        这里的dirent.h是linux下的常用头文件
        使用方法参看
        https://blog.csdn.net/dream_allday/article/details/75243818
    *****************************************************************/
    
    dp = opendir(dir);
  //read all directory and file names in current directory into filename vector
    while((dirp = readdir(dp)) != NULL) 
    {
        filenames.push_back(string(dirp->d_name));
        //push_back是vector对象中的一个方法
        //用于将元素添加到vector对象末尾
        //这里是将一个dirent类型的结构体对象中的d_name(文件名)添加到filenames的末尾
    }
    closedir(dp);
}

void read_file_names(char *dir, vector<string> & buff_str)
{
    DIR *dp;
    struct dirent *dirp;
    dp = opendir(dir);
  //read all directory and file names in current directory into filename vector
    while((dirp = readdir(dp)) != NULL) {
        buff_str.push_back(string(dirp->d_name));
    }
    closedir(dp);
}
 

void testFun1()
{
    ser2usb.printf("hello world\r\n");
    mkdir("/sd/mydir", 0777);
    while(1)
    {
        ser2usb.printf("type in directory:\r\n");
        ser2usb.scanf("%s", mydir);
        ser2usb.printf("Opening %s\n", mydir);
        FILE * fp = fopen(mydir, "w");
        if (fp == NULL)
        {
            ser2usb.printf("Could not open file for write\r\n");
        }
        else
        {
            ser2usb.printf("Open successfully\r\n");
            fprintf(fp, "hello SD\r\n");
            ser2usb.printf("Done, Closing\r\n");
            fclose(fp);
            
            //ser2usb.printf("goodbye\r\n");
            //return 0;
        }
    }
} 

int main ()
{
    //read_file_names("/sd");
    read_file_names("/sd", filenames);
    // print filename strings from vector using an iterator
    for(vector<string>::iterator it=filenames.begin(); it < filenames.end(); it++)
    /******************************  
    这里iterator是vector类中的迭代器对象
    循环里从vector的第一个元素地址开始
    迭代到最后一个
    迭代器的其他用法参看
    https://blog.csdn.net/yyangzhenjie/article/details/74518905
    ******************************/
    {
        ser2usb.printf("%s\n\r",(*it).c_str());
        /***************************
        c_str是string对象的一个方法
        返回一个与string对象内容相同的字符指针
        设计之初是为了和c语言兼容, 因为C语言没有字符串对象
        详细内容参看
        https://zhidao.baidu.com/question/104592558.html
        ****************************/
    }
 
}
