#include "mbed.h"
#include "ADNS3080.h"
#include "LCD_DISCO_F429ZI.h"

ADNS3080 OptFlow(PE_6, PE_5, PE_2, PE_4);//MOSI, MISO, SCLK, NCS
Serial pc(USBTX, USBRX);

LCD_DISCO_F429ZI lcd;

int main() {

    pc.printf("Test ADNS3080\n\r");
    
    pc.printf("prodID is %x\n\r", OptFlow.getProdID());
    pc.printf("RevID is %x\n\r", OptFlow.getRevID());
    pc.printf("InverProdID is %x\n\r", OptFlow.getInverProdID());
    pc.printf("configuration is %x\n\r", OptFlow.getConfiguration_bits()); 
    
    uint8_t text[30];
    BSP_LCD_SetFont(&Font20);
    sprintf((char*)text, "prodID1 is %x", OptFlow.getProdID());
    lcd.DisplayStringAt(0, LINE(0), (uint8_t *)&text, LEFT_MODE);   
    
    int x=0, y=0, dx=0, dy=0;
    while(1){
        OptFlow.getMotion();
        dx = OptFlow.getDelta_X();
        dy = OptFlow.getDelta_Y();
        x += dx;
        y += dy; 
        pc.printf("%4d, %4d, (%d,%d)\n\r", dx, dy, x, y);

        sprintf((char*)text, "(dx,dy)=%4d,%4d", dx, dy);
        lcd.DisplayStringAt(0, LINE(1), (uint8_t *)&text, LEFT_MODE);   
        sprintf((char*)text, "(x,y)=%4d,%4d", x, y);
        lcd.DisplayStringAt(0, LINE(2), (uint8_t *)&text, LEFT_MODE);   

        wait(0.01); 
    }
}
