////////////////////////////////////////////////////////////////
//  Plant Research Rig V1.1.05                                //
//  Michael Steel                                             //
////////////////////////////////////////////////////////////////

// Libraries
#include "mbed.h"
#include "Dht11.h"
#include "ConfigFile.h"
// Define I/O and constants

Serial pc(USBTX, USBRX);
Dht11 sensor(p5);
DigitalIn LOG_SWITCH(p20);
DigitalOut TEMP_BLED(p7);
DigitalOut TEMP_GLED(p8);
DigitalOut TEMP_RLED(p9);
DigitalOut FAN(p10);
DigitalOut HEAT(p11);

LocalFileSystem local("local");
ConfigFile cfg;
float TEMP;
float TEMPHH;
float TEMPH;
float TEMPL;
float TEMPLL;
int TCHECK;
int YEAR;


int main()
{
    // Determins Input file variables
    char *key1 = "TEMPHH";
    char *key2 = "TEMPH";
    char *key3 = "TEMPL";
    char *key4 = "TEMPLL";
    char *key5 = "YEAR";
    char value[BUFSIZ];

    // Read the configuration file from the mbed
    cfg.read("/local/input.cfg");
    if (cfg.getValue(key5, &value[0], sizeof(value))) {
        YEAR = atoi(value) ;
    }
    pc.printf("\r\n Plant Research Rig V1.0 \r\n Resart occured loading variables \r\n");
    // Check correct time and get the current time from the terminal if needed
    struct tm t;
    time_t seconds = time(NULL);
    char buffer[21];
    strftime(buffer, 21, "%Y\n", localtime(&seconds));
    TCHECK = atoi(buffer) ;
    if (TCHECK != YEAR ) {
        printf("Enter current date and time:\n");
        printf("YYYY MM DD HH MM SS[enter]\n");
        scanf("%d %d %d %d %d %d", &t.tm_year, &t.tm_mon, &t.tm_mday
              , &t.tm_hour, &t.tm_min, &t.tm_sec);

        // adjust for tm structure required values
        t.tm_year = t.tm_year - 1900;
        t.tm_mon = t.tm_mon - 1;

        // set the time
        set_time(mktime(&t));

        // display the time
        time_t seconds = time(NULL);
    }
    //printf("\r\n Time as a basic string = %s \r\n", ctime(&seconds));
    wait(1);
    if (cfg.getValue(key1, &value[0], sizeof(value))) {
        pc.printf("'%s'='%s'\r\n", key1, value);
        TEMPHH = atof(value) ;
    } else {
        pc.printf("Failure to get a configuration. Please check config file");
    }
    if (cfg.getValue(key2, &value[0], sizeof(value))) {
        pc.printf("'%s'='%s'\r\n", key2, value);
        TEMPH = atof(value) ;
    }
    if (cfg.getValue(key3, &value[0], sizeof(value))) {
        pc.printf("'%s'='%s'\r\n", key3, value);
        TEMPL = atof(value) ;
    }
    if (cfg.getValue(key4, &value[0], sizeof(value))) {
        pc.printf("'%s'='%s'\r\n", key4, value);
        TEMPLL = atof(value) ;
    }
    pc.printf("Begin logging \r\n");
    while(1) {
        while(LOG_SWITCH == 1) {

            sensor.read() ;
            time_t seconds = time(NULL);
            strftime(buffer, 21,"%X, %x\n", localtime(&seconds));
            FILE *fp = fopen("/local/out.txt", "a");  // Open "out.txt" on the local file system for writing
            fprintf(fp, "\r\n T: %f, H: %f, %s,",sensor.getCelsius(),sensor.getHumidity(),buffer);
            fclose(fp);

            pc.printf("\r\n T: %f, H: %f, %s,",sensor.getCelsius(),sensor.getHumidity(),buffer);
            TEMP = sensor.getCelsius();

            if (TEMP >= TEMPHH) {
                FAN = 1;
                HEAT = 0;
                TEMP_RLED = 1;
                TEMP_GLED = 0;
                TEMP_BLED = 0;
                pc.printf(" Temperature in High Alarm");
            } else if (TEMP >=  TEMPH) {
                FAN = 1;
                HEAT = 0;
                TEMP_RLED = 0;
                TEMP_GLED = 1;
                TEMP_BLED = 0;
            } else if (TEMP >=  TEMPL) {
                FAN = 0;
                HEAT = 0;
                TEMP_RLED = 0;
                TEMP_GLED = 1;
                TEMP_BLED = 0;
            } else if (TEMP >=  TEMPLL) {
                FAN = 0;
                HEAT = 1;
                TEMP_RLED = 0;
                TEMP_GLED = 1;
                TEMP_BLED = 0;
            } else {
                FAN = 0;
                HEAT = 1;
                TEMP_RLED = 0;
                TEMP_GLED = 0;
                TEMP_BLED = 1;
                pc.printf(" Temperature in Low Alarm");
            }
            wait(1);

        }
    }
}
