#include "mbed.h"
#include "Date.h"
 
// http://developer.mbed.org/teams/HIMBED_3AHELI/code/rtc_func/wiki/Homepage
uint8_t Date::bcdToUint(uint8_t const nybbles)
{
    uint8_t result;
    result = (nybbles>>4) + (nybbles & 0x0F);
    return result;
}
 
string Date::toString(uint8_t value)
{
    //return std::to_string(value); // ab C++ version 11
    char buffer[2];
    sprintf (buffer, "%d", value);  // ToString()
    return buffer;
}    
 
uint8_t Date::GetSecond()
{
    uint8_t second = rtc_read(SECONDS);
    return bcdToUint(second & 0x3F);
}

uint8_t Date::GetMinute()
{
    uint8_t minute = rtc_read(MINUTES);
    return bcdToUint(minute & 0x3F);
}

uint8_t Date::GetHour()
{
    uint8_t hour = rtc_read(HOURS);
    return bcdToUint(hour & 0x2F);
}

uint8_t Date::GetDay()
{
    uint8_t day = rtc_read(DAYS);
    return bcdToUint(day & 0x2F);
}

uint8_t Date::GetMonth()
{
    uint8_t month = rtc_read(MONTHS);
    return bcdToUint(month & 0x1F);
}

uint8_t Date::GetYear()
{
    uint8_t year = rtc_read(YEARS);
    return bcdToUint(year & 0x4F);
}