/*motor driver libary modified from the following libary,
*
* mbed simple H-bridge motor controller
* Copyright (c) 2007-2010, S Ford
*
* by Derek Calland modified for a Magnevation PWM Driver Board based on LMD18200T H-Bridge Driver IC's
*
* from Christopher Hasler originally from Simon Ford's libary,
*
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
* THE SOFTWARE.
*/

#include "motordriver.h"

#include "mbed.h"

Motor::Motor(PinName pwm, PinName fwdrev, PinName brake, bool direction, bool stop): ///Class Implementation
    _pwm(pwm), _fwdrev(fwdrev), _brake(brake)
{
    _direction = direction; //Set each motor to rotate in clockwise or counter clockwise
    _stop = stop; //Stop all motion

    // Set initial condition of PWM
    _pwm.period(0.001);
    _pwm = 0;

    // Initial condition of output enables
    _fwdrev = fwdrev; //sets output to drive Motor in a direction
    /* check the motor to see what direction this is from Magnevation Board */

    //Initial condition of Brake
    _brake = brake; //sets brake to ON/OFF condition to Magnevation Board
}

float Motor::speed(float speed, bool direction, bool stop)
{
    _fwdrev = direction;
    _brake = stop; //Sets brake to ON/OFF condition to Magnevation Board
    _pwm = abs(speed);
    return speed;
}

float Motor::stop(float speed, bool stop)
{
    if (speed == 0.0) {
        wait(0.02);
        _brake = stop;
    }
    _pwm = abs(speed);
    return speed;
}


