/*motor driver libary modified from the following libary,
*
* mbed simple H-bridge motor controller
* Copyright (c) 2007-2010, sford
*
*by Derek Calland modified for a Magnevation PWM Driver Board based on LMD18200T H-Bridge Driver IC's
*
*from SFord's libary, and some comments program structure from Christopher Haslers
*
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
* THE SOFTWARE.
*/

#ifndef MBED_MOTOR_H
#define MBED_MOTOR_H

#include "mbed.h"

/** Interface to control a standard DC motor
* with an H-bridge using a PwmOut and 2 DigitalOuts
* Specifically for the Magnevation Board - refer to comments
*/

class Motor   ///Class Declaration
{
public:

    /** Create a motor control interface
    *
    * @param pwm, A PwmOut pin driving the H-bridge enable line to control the speed
    * @param fwdrev, A DigitalOut pin note Forward and Reverse is relative to how you connect the motor(s)
    * and Refer to Figure 4 pages 6 & 7 in Instrument LMD18200 data sheet.
    * @param brake, A DigitalOut pin the Magnevation driver board is able to perform a brake i.e. 0 false brake ON, 1 true brake OFF.
    */
    Motor(PinName pwm, PinName fwdrev, PinName brake, bool direction, bool stop); /** Create Motor instance */
    
    /** Set the speed of the motor
    *
    * @param speed The speed of the motor as a normalised value between 0.0 and 1.0.
    * @param fwdrev Magnevation board sets direction on a pin so does not need -1.0 to 0.0.
    * @param stop The Magnevation Board has a brake facility and incorporates the Current Limiting features of the LMD18200.
    * @return the applied speed to the motor after checking to ensure motor doesn't switch from forward to reverse without stopping.
    */
    float speed(float speed, bool fwdrev, bool stop);

    /** Set the the motor to coast
    *
    * In a practical world you would not neccessarily leave anything 'coasting' and acting as a dc generator
    * always better to have a drive under control at all times so I haven't included this
    * from the origanal class constructor for the Magnevation Board.
    */

    /** Set the motor to dynamicaly brake
    *
    * The Magnevation Board has a brake facility and incorporates the Current Limiting features
    * of the LMD18200.
    */

    float stop(float speed, bool stop);
    /** return the current state of the motor
    */

protected:
    PwmOut _pwm;
    DigitalOut _fwdrev;
    DigitalOut _brake;
    bool _direction;
    bool _stop;

};

#endif
