/*Program Example 3.5: Simple demonstration of 7-segment display. Display digits 0 to 9 in turn.
                                                                       */
#include "mbed.h"
BusOut display_units(p5,p6,p7,p8,p9,p10,p11,p12);   // segments a,b,c,d,e,f,g,DP
BusOut display_tens(p21,p22,p23,p24,p25,p26,p27,p28);
DigitalOut Seconds_Ticker(p30);

char SegConvert( char SegValue);

int main()
{
    while(1) {
        for(char j=0; j<10; j++) {
            display_tens = SegConvert(j);
            for(char i=0; i<10; i++) {
                display_units = SegConvert(i);
                for(int s=0;s<60; s++) {
                Seconds_Ticker = 1;
                wait(0.5);
                Seconds_Ticker = 0;
                wait(0.5);}
            }
        }
    }
}

char SegConvert(char SegValue)
{
    char SegByte=0x00;
    switch (SegValue) {
                                        //DP G F E   D C B A
        case 0: SegByte = 0x3F; break;  //0  0 1 1   1 1 1 1 binary
                                        //display 0
        case 1: SegByte = 0x86; break;  //1  0 0 0   0 1 1 0
                                        //display 1 + DP
        case 2: SegByte = 0x5B; break;
        case 3: SegByte = 0x4F; break;  
        case 4: SegByte = 0x66; break;  
        case 5: SegByte = 0x6D; break;
        case 6: SegByte = 0x7D; break;  
        case 7: SegByte = 0x07; break;  
        case 8: SegByte = 0x7F; break;
        case 9: SegByte = 0x6F; break;  
    }                                      //end of switch
    return SegByte;
}
