#include "mbed.h"
#include "x_nucleo_ike01x1_hum_temp.h"
#include "x_nucleo_ike01x1_pressure.h"
#include "x_nucleo_ike01x1_uv.h"


#ifdef __cplusplus
 extern "C" {
#endif


class Envt_Shield_API
{
    public:
        
        uint8_t Pressure_Init(void);
        uint8_t Pressure_isInitialized(void);
        void Pressure_Reset(void);
        uint8_t Pressure_ReadID(void);
        void Pressure_ITConfig(void/*PRESSURE_InterruptConfigTypeDef *pIntConfigStruct*/);
        void Pressure_EnableIT(uint8_t IntPin);
        void Pressure_DisableIT(uint8_t IntPin);
        void Pressure_GetPressure(float* pfData);
        void Pressure_GetTemperature(float* pfData);
        uint8_t Hum_Temp_Init(void);
        uint8_t Hum_Temp_isInitialized(void);
        void Hum_Temp_Reset(void);
        uint8_t Hum_Temp_ReadID(void);
        void Hum_Temp_ITConfig(void/*HUM_TEMP_InterruptConfigTypeDef *pIntConfig*/);
        void Hum_Temp_EnableIT(uint8_t IntPin);
        void Hum_Temp_DisableIT(uint8_t IntPin);
        void Hum_Temp_GetHumidity(float* pfData);
        void Hum_Temp_GetTemperature(float* pfData);
        void Hum_Temp_PowerOFF();
        uint8_t UV_Init(void);
        uint8_t UV_isInitialized(void);
        uint8_t UV_ReadID(void);
        void UV_Reset(void);
        void UV_ITConfig(void/*UV_InterruptConfigTypeDef *pIntConfig*/);
        void UV_EnableIT(uint8_t IntPin);
        void UV_DisableIT(uint8_t IntPin);
        void UV_GetIndex(float* pfData);
};

#ifdef __cplusplus
}
#endif