#include "nucleo-f401re.h"
#include "Envt_Shield_F4_API.h"
/*#include "x_nucleo_ike01x1_hum_temp.h"
#include "x_nucleo_ike01x1_pressure.h"
#include "x_nucleo_ike01x1_uv.h"*/


uint8_t Envt_Shield_API::Pressure_Init(void)
{
    uint8_t ret= BSP_PRESSURE_Init();
    return ret;
} 

uint8_t Envt_Shield_API::Pressure_isInitialized(void)
{
    uint8_t PressureInitialised=BSP_PRESSURE_isInitialized();
    return PressureInitialised;
}

void Envt_Shield_API::Pressure_Reset(void)
{
    BSP_PRESSURE_Reset();
}

uint8_t Envt_Shield_API::Pressure_ReadID(void)
{
   uint8_t id = BSP_PRESSURE_ReadID();
    return id;
}

void Envt_Shield_API::Pressure_ITConfig(
        void/*PRESSURE_InterruptConfigTypeDef *pIntConfigStruct*/)
{
    BSP_PRESSURE_ITConfig();
}

void Envt_Shield_API::Pressure_EnableIT(uint8_t IntPin)
{
    BSP_PRESSURE_EnableIT(IntPin);
}

void Envt_Shield_API::Pressure_DisableIT(uint8_t IntPin)
{
    BSP_PRESSURE_DisableIT(IntPin);
}

void Envt_Shield_API::Pressure_GetPressure(float* pfData)
{
    BSP_PRESSURE_GetPressure(pfData);
}

void Envt_Shield_API::Pressure_GetTemperature(float* pfData)
{
    BSP_PRESSURE_GetTemperature(pfData);
}


uint8_t Envt_Shield_API::Hum_Temp_Init(void)
{
    uint8_t ret = BSP_HUM_TEMP_Init();
    return ret;
}

uint8_t Envt_Shield_API::Hum_Temp_isInitialized(void)
{
    uint8_t HumpTempInitialised=BSP_HUM_TEMP_isInitialized();
    return HumpTempInitialised;
}

void Envt_Shield_API::Hum_Temp_Reset(void)
{
    BSP_HUM_TEMP_Reset();
}

uint8_t Envt_Shield_API::Hum_Temp_ReadID(void)
{
    uint8_t id = BSP_HUM_TEMP_ReadID();
    return id;
}

void Envt_Shield_API::Hum_Temp_ITConfig(
        void/*HUM_TEMP_InterruptConfigTypeDef *pIntConfig*/)
{
    BSP_HUM_TEMP_ITConfig();
}

void Envt_Shield_API::Hum_Temp_EnableIT(uint8_t IntPin)
{
    BSP_HUM_TEMP_EnableIT(IntPin);
}

void Envt_Shield_API::Hum_Temp_DisableIT(uint8_t IntPin)
{
     BSP_HUM_TEMP_DisableIT(IntPin);
}

void Envt_Shield_API::Hum_Temp_GetHumidity(float* pfData)
{
     BSP_HUM_TEMP_GetHumidity(pfData);
}

void Envt_Shield_API::Hum_Temp_GetTemperature(float* pfData)
{
   BSP_HUM_TEMP_GetTemperature(pfData);
}

void Envt_Shield_API::Hum_Temp_PowerOFF()
{
    BSP_HUM_TEMP_PowerOFF();
}

uint8_t Envt_Shield_API::UV_Init(void)
{  
    uint8_t ret = BSP_UV_Init();
    return ret;
}

uint8_t Envt_Shield_API::UV_isInitialized(void)
{
    uint8_t UvInitialized=BSP_UV_isInitialized();
    return UvInitialized;
}

/**
 * @brief  Read ID of Uv component
 * @param  None
 * @retval ID
 */
uint8_t Envt_Shield_API::UV_ReadID(void)
{
    uint8_t id = BSP_UV_ReadID();
    return id;
}

/**
 * @brief  Reboot memory content of UV
 * @param  None
 * @retval None
 */
void Envt_Shield_API::UV_Reset(void)
{  
    BSP_UV_Reset();
}


/**
 * @brief  Configure INT1 interrupt
 * @param  pIntConfig: pointer to a UVIS3_InterruptConfig_TypeDef
 *         structure that contains the configuration setting for the UVIS3 Interrupt.
 * @retval None
 */
void Envt_Shield_API::UV_ITConfig(void/*UV_InterruptConfigTypeDef *pIntConfig*/)
{
    BSP_UV_ITConfig();
}

/**
 * @brief  Enable INT1 or INT2 interrupt
 * @param  IntPin: Interrupt pin
 *      This parameter can be:
 *        @arg UVIS3_INT1
 *        @arg UVIS3_INT2
 * @retval None
 */
void Envt_Shield_API::UV_EnableIT(uint8_t IntPin)
{
    BSP_UV_EnableIT(IntPin);
}

/**
 * @brief  Disable INT1 or INT2 interrupt
 * @param  IntPin: Interrupt pin
 *      This parameter can be:
 *        @arg UVIS3_INT1
 *        @arg UVIS3_INT2
 * @retval None
 */
void Envt_Shield_API::UV_DisableIT(uint8_t IntPin)
{
    BSP_UV_DisableIT(IntPin);
}

/**
 * @brief  Get Index UV
 * @param pfData: pointer on floating data
 * @retval None
 */
void Envt_Shield_API::UV_GetIndex(float* pfData)
{
    BSP_UV_GetIndex(pfData);
}