/**
  ******************************************************************************
  * @file    x_nucleo_ike01x1_hum_temp.h
  * @author  AST Robotics Team
  * @version V0.0.1
  * @date    08-April-2014
  * @brief   This file contains definitions for x_nucleo_ike01x1_hum_temp.c 
  *          firmware driver.
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; COPYRIGHT(c) 2014 STMicroelectronics</center></h2>
  *
  * Redistribution and use in source and binary forms, with or without modification,
  * are permitted provided that the following conditions are met:
  *   1. Redistributions of source code must retain the above copyright notice,
  *      this list of conditions and the following disclaimer.
  *   2. Redistributions in binary form must reproduce the above copyright notice,
  *      this list of conditions and the following disclaimer in the documentation
  *      and/or other materials provided with the distribution.
  *   3. Neither the name of STMicroelectronics nor the names of its contributors
  *      may be used to endorse or promote products derived from this software
  *      without specific prior written permission.
  *
  * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
  * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
  * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
  * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
  * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
  *
  ******************************************************************************
  */
  

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __X_NUCLEO_IKE01X1_HUM_TEMP_H
#define __X_NUCLEO_IKE01X1_HUM_TEMP_H

#ifdef __cplusplus
 extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
//#include "x_nucleo_ike01x1.h"
/* Include HUM_TEMP sensor component driver */
#include "../Components/hts221/hts221.h"

/** @addtogroup BSP
  * @{
  */
  
/** @addtogroup X_NUCLEO_IKE01X1
  * @{
  */ 

/** @addtogroup X_NUCLEO_IKE01X1_HUM_TEMP
  * @{
  */
  
/** @defgroup X_NUCLEO_IKE01X1_HUM_TEMP_Exported_Types X_NUCLEO_IKE01X1_HUM_TEMP_Exported_Types
  * @{
  */
typedef enum 
{
  HUM_TEMP_OK = 0,
  HUM_TEMP_ERROR = 1,
  HUM_TEMP_TIMEOUT = 2
} 
HUM_TEMP_StatusTypeDef;

/**
  * @}
  */
  
/** @defgroup X_NUCLEO_IKE01X1_HUM_TEMP_Exported_Constants X_NUCLEO_IKE01X1_HUM_TEMP_Exported_Constants
  * @{
  */

/**
  * @}
  */
  
/** @defgroup X_NUCLEO_IKE01X1_HUM_TEMP_Exported_Macros X_NUCLEO_IKE01X1_HUM_TEMP_Exported_Macros
  * @{
  */

/**
  * @}
  */
 
/** @defgroup X_NUCLEO_IKE01X1_HUM_TEMP_Exported_Functions X_NUCLEO_IKE01X1_HUM_TEMP_Exported_Functions
  * @{
  */

/* Sensor Configuration Functions */ 
uint8_t BSP_HUM_TEMP_Init(void);
uint8_t BSP_HUM_TEMP_isInitialized(void);
void    BSP_HUM_TEMP_PowerOFF(void);
uint8_t BSP_HUM_TEMP_ReadID(void);
void    BSP_HUM_TEMP_Reset(void);
void    BSP_HUM_TEMP_ITConfig(void/*HUM_TEMP_InterruptConfigTypeDef *pIntConfigStruct*/);
void    BSP_HUM_TEMP_EnableIT(uint8_t IntPin);
void    BSP_HUM_TEMP_DisableIT(uint8_t IntPin);
void    BSP_HUM_TEMP_GetHumidity(float* pfData);
void    BSP_HUM_TEMP_GetTemperature(float* pfData);


/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */
  
/**
  * @}
  */
  
#ifdef __cplusplus
  }
#endif
  
#endif /* __X_NUCLEO_IKE01X1_HUM_TEMP_H */
  


/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/ 

