/**
 ******************************************************************************
 * @file    x_nucleo_ike01x1_uv.c
 * @author  AST Robotics Team
 * @version V0.0.1
 * @date    10-March-2014
 * @brief   This file provides a set of functions needed to manage the uvis3 sensor.
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; COPYRIGHT(c) 2014 STMicroelectronics</center></h2>
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *   1. Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 *   3. Neither the name of STMicroelectronics nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************
 */
/* Includes ------------------------------------------------------------------*/
#include "x_nucleo_ike01x1_uv.h"

/** @addtogroup BSP
 * @{
 */

/** @addtogroup X_NUCLEO_IKE01X1
 * @{
 */

/** @addtogroup X_NUCLEO_IKE01X1_UV
 * @{
 */


/** @defgroup X_NUCLEO_IKE01X1_UV_Private_TypesDefinitions X_NUCLEO_IKE01X1_UV_Private_TypesDefinitions
 * @{
 */

/**
 * @}
 */

/** @defgroup X_NUCLEO_IKE01X1_UV_Private_Defines X_NUCLEO_IKE01X1_UV_Private_Defines
 * @{
 */
#ifndef NULL
  #define NULL      (void *) 0
#endif
/**
 * @}
 */

/** @defgroup X_NUCLEO_IKE01X1_UV_Private_Macros X_NUCLEO_IKE01X1_UV_Private_Macros
 * @{
 */

/**
 * @}
 */

/** @defgroup X_NUCLEO_IKE01X1_UV_Private_Variables X_NUCLEO_IKE01X1_UV_Private_Variables
 * @{
 */
static UV_DrvTypeDef *UvDrv;
static uint8_t UvInitialized = 0;

/**
 * @}
 */

/** @defgroup X_NUCLEO_IKE01X1_UV_Private_FunctionPrototypes X_NUCLEO_IKE01X1_UV_Private_FunctionPrototypes
 * @{
 */

/**
 * @}
 */

/** @defgroup X_NUCLEO_IKE01X1_UV_Private_Functions X_NUCLEO_IKE01X1_UV_Private_Functions
 * @{
 */

/**
 * @brief  Set UV Initialization.
 * @param  None
 * @retval UV_OK if no problem during initialization
 */
uint8_t BSP_UV_Init(void)
{  
    uint8_t ret = UV_ERROR;
    UV_InitTypeDef UVIS3_InitStructure;
    //UV_FilterConfigTypeDef UVIS3_FilterStructure={0,0};

    /* Initialize the uv driver structure */
    UvDrv = &Uvis3Drv;

    /* Configure sensor */
    UVIS3_InitStructure.Power_Mode = UVIS3_MODE_ACTIVE;
    UVIS3_InitStructure.Output_DataRate = UVIS3_ODR_1HZ;

    /* Uvis3 Init */   
    UvDrv->Init(&UVIS3_InitStructure);

    if(UvDrv->ReadID() == I_AM_UVIS3)
    {
        UvInitialized = 1;
        ret = UV_OK;
    }

    return ret;
}

uint8_t BSP_UV_isInitialized(void)
{
    return UvInitialized;
}

/**
 * @brief  Read ID of Uv component
 * @param  None
 * @retval ID
 */
uint8_t BSP_UV_ReadID(void)
{
    uint8_t id = 0x00;

    if(UvDrv->ReadID != NULL)
    {
        id = UvDrv->ReadID();
    }
    return id;
}

/**
 * @brief  Reboot memory content of UV
 * @param  None
 * @retval None
 */
void BSP_UV_Reset(void)
{  
    if(UvDrv->Reset != NULL)
    {
        UvDrv->Reset();
    }
}


/**
 * @brief  Configure INT1 interrupt
 * @param  pIntConfig: pointer to a UVIS3_InterruptConfig_TypeDef
 *         structure that contains the configuration setting for the UVIS3 Interrupt.
 * @retval None
 */
void BSP_UV_ITConfig(void/*UV_InterruptConfigTypeDef *pIntConfig*/)
{
    // uint16_t interruptconfig = 0x0000;

    // if(UvDrv->ConfigIT != NULL)
    // {
    // /* Configure latch Interrupt request and axe interrupts */                   
    // interruptconfig |= ((uint8_t)(pIntConfig->Latch_Request| \
    // pIntConfig->Interrupt_Axes) << 8);

    // interruptconfig |= (uint8_t)(pIntConfig->Interrupt_ActiveEdge);

    // UvDrv->ConfigIT(interruptconfig);
    // }
}

/**
 * @brief  Enable INT1 or INT2 interrupt
 * @param  IntPin: Interrupt pin
 *      This parameter can be:
 *        @arg UVIS3_INT1
 *        @arg UVIS3_INT2
 * @retval None
 */
void BSP_UV_EnableIT(uint8_t IntPin)
{
    if(UvDrv->EnableIT != NULL)
    {
        UvDrv->EnableIT(IntPin);
    }
}

/**
 * @brief  Disable INT1 or INT2 interrupt
 * @param  IntPin: Interrupt pin
 *      This parameter can be:
 *        @arg UVIS3_INT1
 *        @arg UVIS3_INT2
 * @retval None
 */
void BSP_UV_DisableIT(uint8_t IntPin)
{
    if(UvDrv->DisableIT != NULL)
    {
        UvDrv->DisableIT(IntPin);
    }
}

/**
 * @brief  Get Index UV
 * @param pfData: pointer on floating data
 * @retval None
 */
void BSP_UV_GetIndex(float* pfData)
{
    if(UvDrv->GetIndex!= NULL)
    {
        UvDrv->GetIndex(pfData);
    }
}

/**
 * @}
 */

/**
 * @}
 */

/**
 * @}
 */

/**
 * @}
 */

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/     

