#include "mbed.h"
#include "nucleo-f401re.h"
#include "x_nucleo_ike01x1_pressure.h"
#include "x_nucleo_ike01x1_uv.h"
#include "x_nucleo_ike01x1_hum_temp.h"
//------------------------------------
// Hyperterminal configuration
// 9600 bauds, 8-bit data, no parity
//------------------------------------
uint8_t PRESInit=0;
uint8_t UVInit=0;
uint8_t HumTempInit=0;
/*Global variables */
uint8_t HumTempId=0;
uint8_t PressID=0;
int dec_precision = 2;
 volatile float UVI_Value;
 volatile float PRESSURE_Value;
 volatile float HUMIDITY_Value;
 volatile float TEMPERATURE_Value;
void floatToInt(float in, int32_t *out_int, int32_t *out_dec, int32_t dec_prec);
Serial pc(SERIAL_TX, SERIAL_RX);
 
DigitalOut myled(LED1);
 
int main() 
  {
  
  int mul = 1;
  for(int i = 0; i < dec_precision; i++)
     mul = mul*10;
     
  if(!BSP_HUM_TEMP_isInitialized()) {     
     BSP_HUM_TEMP_Init();     //This also Inits I2C interface from here.   
    }
  HumTempId = BSP_HUM_TEMP_ReadID();
    if(HumTempId==I_AM_HTS221){
        HumTempInit=1;
    }    
  /*End Temp Sensor Init*/
  
  /*Initialize the pressure sensors*/
  if(!BSP_PRESSURE_isInitialized()) {     
     BSP_PRESSURE_Init();     //This also Inits I2C interface from here.  
     PRESInit=1;
    }
  PressID = BSP_PRESSURE_ReadID();
 
  int32_t d1, d2, d3, d4;
    
  pc.printf("Hello World !\n");
  while(1) { 
      wait(1);
      
      if(BSP_HUM_TEMP_isInitialized()) 
      {
        BSP_HUM_TEMP_GetHumidity((float *)&HUMIDITY_Value);
        BSP_HUM_TEMP_GetTemperature((float *)&TEMPERATURE_Value);
        
        floatToInt(HUMIDITY_Value, &d1, &d2, mul);
        floatToInt(TEMPERATURE_Value, &d3, &d4, mul);
        pc.printf("H: %d.%02d    T: %d.%02d", d1, d2, d3, d4);
         
        }
        
        if(BSP_PRESSURE_isInitialized())
        {   
            BSP_PRESSURE_GetPressure((float *)&PRESSURE_Value);
            floatToInt(PRESSURE_Value, &d1, &d2, mul);
            pc.printf(" P: %d.%02d\n", d1, d2);
            
        }
        
        if(BSP_UV_isInitialized())
         {
            BSP_UV_GetIndex((float *)&UVI_Value);
            floatToInt(UVI_Value, &d1, &d2, mul);
            pc.printf("UV: %d.%02d\n", d1, d2);
         }
      
                  pc.printf("Done");
      myled = !myled;
  }
}
void floatToInt(float in, int32_t *out_int, int32_t *out_dec, int32_t dec_prec)
{
    *out_int = (int32_t)in;
    in = in - (float)(*out_int);
    *out_dec = (int32_t)(in*dec_prec);
}