/**
  ******************************************************************************
  * @file    uvis3.c
  * @author  AST Robotics Team
  * @version V0.0.1
  * @date    10-March-2014
  * @brief   This file provides a set of functions needed to manage the uvis3.
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; COPYRIGHT(c) 2014 STMicroelectronics</center></h2>
  *
  * Redistribution and use in source and binary forms, with or without modification,
  * are permitted provided that the following conditions are met:
  *   1. Redistributions of source code must retain the above copyright notice,
  *      this list of conditions and the following disclaimer.
  *   2. Redistributions in binary form must reproduce the above copyright notice,
  *      this list of conditions and the following disclaimer in the documentation
  *      and/or other materials provided with the distribution.
  *   3. Neither the name of STMicroelectronics nor the names of its contributors
  *      may be used to endorse or promote products derived from this software
  *      without specific prior written permission.
  *
  * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
  * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
  * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
  * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
  * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
  *
  ******************************************************************************
  */
/* Includes ------------------------------------------------------------------*/
#include "uvis3.h"

/** @addtogroup BSP
  * @{
  */ 

/** @addtogroup STM32F439_SENSITRON
  * @{
  */ 

/** @addtogroup UVIS3
  * @{
  */


/** @defgroup UVIS3_Private_TypesDefinitions
  * @{
  */
  
/**
  * @}
  */

/** @defgroup UVIS3_Private_Defines
  * @{
  */

/**
  * @}
  */

/** @defgroup UVIS3_Private_Macros
  * @{
  */

/**
  * @}
  */ 
  
/** @defgroup UVIS3_Private_Variables
  * @{
  */ 

UV_DrvTypeDef Uvis3Drv =
{
  UVIS3_Init,
  UVIS3_ReadID,
  UVIS3_RebootCmd,
  0,//UVIS3_INT1InterruptConfig,
  0,//UVIS3_EnableIT,
  0,//UVIS3_DisableIT,
  0,
  0,
  UVIS3_GetIndex
};
/**
  * @}
  */

/** @defgroup UVIS3_Private_FunctionPrototypes
  * @{
  */

/**
  * @}
  */

/** @defgroup UVIS3_Private_Functions
  * @{
  */

/**
  * @brief  Set UVIS3 Initialization.
  * @param  InitStruct: it contains the configuration setting for the UVIS3.
  * @retval None
  */
void UVIS3_Init(UV_InitTypeDef *UVIS3_Init)
{  
    uint8_t ctrl = 0x00;

    /* Configure the low level interface ---------------------------------------*/
    UV_IO_Init();

    /* Read CTRL_REG1 register */
    UV_IO_Read(&ctrl, UVIS3_ADDRESS, UVIS3_CTRL_REG1_ADDR, 1);

    /* Power Mode selection */
    ctrl &= ~(UVIS3_MODE_MASK);
    ctrl |= UVIS3_Init->Power_Mode;

//    if(UVIS3_Init->Power_Mode==UVIS3_MODE_POWERDOWN) {
//        ctrl |= 0x80;
//    } else {
//        ctrl &= 0x7F;
//    }

    /* Data Rate selection */
    ctrl &= ~(UVIS3_ODR_MASK);
    ctrl |= UVIS3_Init->Output_DataRate;

//    if(UVIS3_Init->Output_DataRate==UVIS3_ODR_1HZ) {
//        ctrl |= 0x01;
//    } else {
//        ctrl &= 0xFE;
//    }

    /* Write value to MEMS CTRL_REG1 regsister */
    UV_IO_Write(&ctrl, UVIS3_ADDRESS, UVIS3_CTRL_REG1_ADDR, 1);

    /* Write value to MEMS CTRL_REG2 regsister  ??*/
    //ctrl = (uint8_t) InitStruct>>8;
    //UV_IO_Write(&ctrl, UVIS3_CTRL_REG2_ADDR, 1);
}

/**
  * @brief  Read ID address of UVIS3
  * @param  Device ID address
  * @retval ID name
  */
uint8_t UVIS3_ReadID(void)
{
  uint8_t tmp;

  /* Read WHO I AM register */
  UV_IO_Read(&tmp, UVIS3_ADDRESS, UVIS3_WHO_AM_I_ADDR, 1);
    
  /* Return the ID */
  return (uint8_t)tmp;
}

/**
  * @brief  Reboot memory content of UVIS3
  * @param  None
  * @retval None
  */
void UVIS3_RebootCmd(void)
{
  uint8_t tmpreg;
  
  /* Read CTRL_REG5 register */
  UV_IO_Read(&tmpreg, UVIS3_ADDRESS, UVIS3_CTRL_REG2_ADDR, 1);
  
  /* Enable or Disable the reboot memory */
  tmpreg |= UVIS3_BOOT_REBOOTMEMORY;
  
  /* Write value to MEMS CTRL_REG5 regsister */
  UV_IO_Write(&tmpreg, UVIS3_ADDRESS, UVIS3_CTRL_REG2_ADDR, 1);
}

/**
  * @brief Set UVIS3 Interrupt INT1 configuration
  * @param  UVIS3_InterruptConfig_TypeDef: pointer to a UVIS3_InterruptConfig_TypeDef 
  *         structure that contains the configuration setting for the UVIS3 Interrupt.
  * @retval None
  */
void UVIS3_INT1InterruptConfig(uint16_t Int1Config)
{
 
}

/**
  * @brief  Enable INT1
  * @retval None
  */
void UVIS3_EnableIT()
{  

}

/**
  * @brief  Disable  INT1
  * @retval None
  */
void UVIS3_DisableIT()
{  

}


/**
* @brief  Calculate the UVIS3 UV index data.
* @param  pfData : Data out pointer
* @retval None
*/
void UVIS3_GetIndex(float* pfData)
{
  uint8_t tmpreg;   
  /* Read UVIS3_UVDATA_OUT_ADDR register */
  UV_IO_Read(&tmpreg, UVIS3_ADDRESS, UVIS3_UVDATA_OUT_ADDR, 1);
  //tmpreg=32;
  *pfData=(float)tmpreg/16.0f; 

}

/**
  * @}
  */ 

/**
  * @}
  */ 
  
/**
  * @}
  */ 

/**
  * @}
  */ 
  

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/     

