/* mbed Serial Flow Library
 * Copyright (c) 2012 Oleg Evsegneev
 * Released under the MIT License: http://mbed.org/license/mit
 */

#ifndef MBED_SERIALFLOW_H
#define MBED_SERIALFLOW_H

// optional use of MODSERIAL
#define USE_MODSERIAL

#include "mbed.h"

#ifdef USE_MODSERIAL
#include "MODSERIAL.h"
#endif

#define MAX_PACKET_SIZE 10
#define RX_BUFFER_SIZE 32
#define TX_BUFFER_SIZE 32

class SerialFlow {

public:
    /** Data format */
    enum DataFormat {
        SIMPLE     /**< Simple one byte (default) */
        , COMPLEX  /**< Packet of many short values */
    };
    
    SerialFlow(PinName tx, PinName rx);

    /** Set portal baud rate
     *
     * @param baud_rate Port baud rate.
     */
    void baud(int baud_rate);

    /** Set data packet format
     *
     * @param p_format Format type constant.
     * @param v_length Length of value in bytes.
     * @param p_size Number of values.
     */
    void setPacketFormat(DataFormat p_format, char v_length, char p_size);

    /**  Set value to data packet
     *
     * @param value Value.
     */
    void setPacketValue(short value);
        
    /**  Send packet to serial port
     */
    bool sendPacket();

    /**  Receive packet from serial port
     */
    bool receivePacket();

    /**  Get received packet
     * @param idx Index of value from packet.
     */
    short getPacket( char idx );

protected:
    #ifdef USE_MODSERIAL
    MODSERIAL _serial;
    #else
    Serial _serial;
    #endif

    char _p_format;
    char _p_size;
    char _v_length;

    short _vs[MAX_PACKET_SIZE];
    char _vs_idx;

    short _vr[MAX_PACKET_SIZE];
    char _vr_val[2];
    char _vr_idx;
    char _cr_idx;
    bool _escape;
    bool _collecting;
};

#endif
