/* mbed Serial Flow Library
 * Copyright (c) 2012 Oleg Evsegneev
 * Released under the MIT License: http://mbed.org/license/mit
 */
 
#include "SerialFlow.h"
#include "mbed.h"

#ifdef USE_MODSERIAL
SerialFlow::SerialFlow(PinName tx, PinName rx): _serial(tx, rx, TX_BUFFER_SIZE, RX_BUFFER_SIZE) {
#else
SerialFlow::SerialFlow(PinName tx, PinName rx): _serial(tx, rx) {
#endif
    _escape = 0;
    _collecting = 0;
}

void SerialFlow::baud(int baud_rate) {
    _serial.baud(baud_rate);
}

void SerialFlow::setPacketFormat(DataFormat p_format, char v_length, char p_size) {
    _p_format = p_format;
    _v_length = v_length;
    _p_size = p_size;
    _vs_idx = 0;
    _vr_idx = 0;
}

void SerialFlow::setPacketValue(short value) {
    if( _vs_idx < _p_size ){
        _vs[_vs_idx++] = value;
    }
}

bool SerialFlow::sendPacket() {
    char v;
    if( !_serial.writeable() ){
        _vs_idx = 0;
        return 0;
    }
        
    _serial.putc( 0x12 );
    for( char i=0; i<_vs_idx; i++ ){
        // low byte
        v = _vs[i] & 0xFF;
        if( v==0x12 || v==0x13 || v==0x7D || v==0x10 )
            _serial.putc( 0x7D );
        _serial.putc( v );

        // high byte
        v = (_vs[i]>>8) & 0xFF;
        if( v==0x12 || v==0x13 || v==0x7D || v==0x10 )
            _serial.putc( 0x7D );
        _serial.putc( v );
            
        // separate values
        if( i<_vs_idx-1 )
            _serial.putc(0x10);
    }
        
    _serial.putc( 0x13 );
    _vs_idx = 0;
    return 1;
}

bool SerialFlow::receivePacket() {
    char c;
    while( _serial.readable() ){
        c = _serial.getc();
        if( _collecting )
            if( _escape ){
                _vr_val[_cr_idx++] = c;
                _escape = 0;
            }
            // escape
            else if( c == 0x7D ){
                _escape = 1;
            }
            // value separator
            else if( c == 0x10 ){
                _vr[_vr_idx++] = _vr_val[0] | (_vr_val[1] << 8);
                _cr_idx = 0;
            }    
            // end
            else if( c == 0x13 ){
                _vr[_vr_idx++] = _vr_val[0] | (_vr_val[1] << 8);
                _collecting = 0;
                return 1;
            }    
            else{
                _vr_val[_cr_idx++] = c;
            }    
        // begin
        else if( c == 0x12 ){
            _collecting = 1;
            _cr_idx = 0;
            _vr_idx = 0;
        }    
    }
    return 0;
}

short SerialFlow::getPacket( char idx ) {
    return _vr[idx];
}
