/* Log system for FRAM+FLASH
* Copyright (c) 2012 Oleg Evsegneev
* Released under the MIT License: http://mbed.org/license/mit
*/

#ifndef MBED_FILELOG_H
#define MBED_FILELOG_H
  
#include "mbed.h"
#include "FRAMSPI.h"

#define LOG_FILE "/local/log.txt"

/* FRAM log system main class
*
* @code
* #include "mbed.h"
* #include "FRAMLog.h"
* 
* SPI spi(p5,p6,p7);
* FRAMLog flog(spi, p8, 4, 2048);
* Serial pc(USBTX, USBRX);
* 
* int main() {
*     for( int i=0; i<2048; i++){
*         flog.log(i/4096.0);
*         flog.log(i/(4096.0+1));
*         flog.log(i/(4096.0+2));
*         flog.log(i/(4096.0+3));
*     }
*     flog.save();
* }
* @endcode
*/

class FRAMLog {

public:
    FRAMLog( SPI& spi, PinName ncs, short cols, short rows );

    /** Set new value to log
     *
     * @param value Value of log entry.
     */
    void log( float val );

    /**  Save log to file on flash
     *
     */
    void save();
        
protected:
    FRAMSPI _fram;
    LocalFileSystem _local;
    unsigned short _addr;
    short _cols;
    short _rows;
    short _row;
    void toArray( float val, char *bytes );
    float fromArray( char *bytes );
};

#endif
