/* Log system for FRAM+FLASH
* Copyright (c) 2012 Oleg Evsegneev
* Released under the MIT License: http://mbed.org/license/mit
*
* Datasheet http://www.ramtron.com/files/datasheets/FM25V02_ds.pdf
*/
 
#include "mbed.h"
#include "FRAMLog.h"

FRAMLog::FRAMLog( SPI& spi, PinName ncs, short cols, short rows ): _fram(spi, ncs), _local("local") {
    _cols = cols;
    _rows = rows;
    _addr = 0;
    _row = 0;
}

float FRAMLog::fromArray( char *bytes ){
    union {
        float f;
        unsigned char b[4];
    } v;

    for( char i=0; i<4; i++ )
        v.b[i] = bytes[i];

    return v.f;
}

void FRAMLog::toArray( float val, char *bytes ){
    union {
        float f;
        unsigned char b[4];
    } v;
    v.f = val;

    for( char i=0; i<4; i++ )
        bytes[i] = v.b[i];
}

void FRAMLog::log( float val ) {
    char bytes[4];
    toArray( val, bytes );
    _fram.write(_addr, bytes, 4);
    _addr += 4;
    if( ( _addr % (_cols*4)) == 0 )
        _row++;
}

void FRAMLog::save() {
    FILE *fp = fopen(LOG_FILE, "w");
    char bytes[4];
    unsigned short addr = 0;
    
    for( short i=0; i<_row; i++){
        for( short k=0; k<_cols; k++){
            _fram.read(addr, bytes, 4);
            addr += 4;
            fprintf( fp, "%.4f", fromArray(bytes));
            if( k < _cols-1 )
                fprintf( fp, "\t");
        }
        fprintf( fp, "\r\n");
    }
    fclose(fp);
}
