#include "Grove_LCD_RGB_Backlight.h"
#include "mbed.h"
/*
I used the "Grove RGB LCD Display" by Chandler Matz
https://developer.mbed.org/users/cmatz3/notebook/grove-rgb-lcd-display/
as a platform to create a remote control with display for a
10hp up-cut saw that cuts aluminum, plastic and other materials. It is 
controlled by a Variable Frequency Drive (VFD) which is mounted at the 
back of the saw, making it inconvienient to change the blade speed 
to match the material being cut.
****USED****
Board = FRDM-K22F 
Pot = 50K multi-turn
VFD = Leasson Speedmaster series
Analog input over pot from control 0-10V (T2, T5)
Analog output from terminal (T30) 0-10V
3 x 3.3K ohm resistors
1 x 6.2K ohm  
2 of the 3.3k are pull ups for I2C and the other is in series with 
6.2K from T30 for ain max of 1mA @ 10V = 3.47V (this came out to be very 
close to the K22 supply from the FRDM board)
*/

AnalogIn pot(PTB0); //Voltage from VFD reference pin in the FRDM-K22F
Grove_LCD_RGB_Backlight rgbLCD(PTE0, PTE1);
I2C i2c(PTE0, PTE1);



int main()
{
   float ain;  // VFD reference pin 
   char volts[12];  // make a 'volts' string
   ain = pot.read()*3550;  // Voltage from VFD * the maximum blade RPM 
   sprintf(volts, "%f", ain); // send ain to volts
   rgbLCD.clear(); // Just 
   wait(5);
   rgbLCD.print("Blade Speed ");
   rgbLCD.setRGB(0x00, 0x66, 0xaa); 
   rgbLCD.locate(0,1);
   rgbLCD.print(volts);
   wait(.5);
   int count = 0;
   while(1)
   {
     if (count < 0x0fffffff)
     {
         ain = pot.read()*3550;
         sprintf(volts, "%f", ain);
         rgbLCD.locate(0,1);
         rgbLCD.print(volts);
         wait(.5);
         count ++;
     }   
     else 
     {
         ain = pot.read()*3550;
         sprintf(volts, "%f", ain);
         rgbLCD.locate(0,1);
         rgbLCD.print(volts);
         wait(.5);
         count = 0;
   
     }
    

     
     
   }
}