#include "mbed.h"
#include "Servo.h"

Servo motor_servo(PTB1);
Servo rudder_servo(PTB0);
Serial device(PTE0, PTE1); //Device tx and rx at PTE0 and PTE1
DigitalOut led1(LED1);
DigitalOut led2(LED2);
//Use LEDS to indicate RF link activity
//Use PC terminal to write messages


int main() {
    // Wait for ESC signal
    motor_servo = 0.0;
    wait(1);
    // Arm ESC by sending longest and shortest PWM signal
    motor_servo = 1.0;
    wait(1);
    motor_servo = 0.0;
    
    // Centre rudder
    rudder_servo = 0.5;
    
    float speed = 0.0;
    bool start_flag = false;
    char command;
    device.baud(9600);
    device.printf("Wireless UART connection initialised.\nVehicle in manual control mode.\n");
    
    // Wait for start command
    device.printf("Press 'r' to start.\n\r");
    while (!start_flag) {
        if (device.readable() != 0) command = device.getc();
        if (command == 'r') start_flag = true;
    }
    device.printf("Ready to accept commands.\n\r");
    
    while(1) {    
        while (device.readable() != 0) {
                
                // w - increase speed
                // s - decrease speed
                // a - tilt rudder right
                // d - tilt rudder left
                // r - reset to default values
                command = device.getc();

                switch (command){
                case 'w':
                    if (speed < 1.0) speed = speed + 0.01;
                    motor_servo = speed;
                    device.printf("Motor speed increased to %f\n\r", speed);
                    break;
                    
                case 's':
                    if (speed > 0.0) speed = speed - 0.01;
                    motor_servo = speed;
                    device.printf("Motor speed decreased to %f\n\r", speed);
                    break;
                    
                case 'a':
                    if (rudder_servo > 0.3) rudder_servo = rudder_servo - 0.1;
                    device.printf("Rudder tilted right\n\r");
                    break;
                    
                case 'd':
                    if (rudder_servo < 0.8) rudder_servo = rudder_servo + 0.1;
                    device.printf("Rudder tilted left\n\r");
                    break;
                    
                case 'r':
                    speed = 0.0;
                    motor_servo = speed;
                    rudder_servo = 0.5;
                    device.printf("Reset motor speed to %f\n\r", speed);
                    break;
            }  
        }                            
    } 
}
