/* MMEx for MBED - processing for U commands
 * Copyright (c) 2011 MK
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/**
  \file ufuncs.h
  \brief processing for U commands, to be filled in by users
*/

#ifndef UFUNCS_H
#define UFUNCS_H

#include "mmex.h"

// definition of the U-functions for User defined functions

#define utemp  'T'
#define ustack 'S'
#define ualpha 'A'


extern char regX[14];
extern char regY[14];
extern char regZ[14];
extern char regT[14];
extern char regL[14];
extern char regA[29];

int read_reg(char *reg);
void show_reg(char *c, char *reg);
void parse_U();
void do_utemp();
void do_ustack();
void do_ualpha();

void do_udefault();

#endif