/* MMEx for MBED - MMEx specific functions
 * Copyright (c) 2011 MK
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/**
  \file mmex.h
  \brief MMEx specific functions with all global includes
*/

#ifndef MMEX_H
#define MMEX_H

#include "spissp.h"
#include "mbed.h"

#include "mbeddefs.h"

#include "rpc.h"
#include "RPCFunction.h"
#include "RPCVariable.h"

#include "helper.h"
#include "debug.h"

#include "cfuncs.h"
#include "ffuncs.h"
#include "mfuncs.h"
#include "nfuncs.h"
#include "pfuncs.h"
#include "rfuncs.h"
#include "ufuncs.h"

#include "MSCFileSystem.h"
#include "SDFileSystem.h"

#include <string>        // allow use of string classes

#include "EthernetNetIf.h"
#include "HTTPClient.h"
#include "NTPClient.h"
#include "HTTPServer.h"
#include "HTTPStream.h"
#include "RPCFunction.h"

#define bufsize 255

extern char inbuf[bufsize];                     
extern char outbuf[bufsize];

extern int rx_max;
extern int tx_max;

// startup values
#define start_baud 9600       // baudrate after startup

#define c_error   'E'
#define c_busy    'B'

#define c_rpc     '/'
#define c_rpcapp  '+'
#define c_rpcexe  '*'

// control strings
#define cc_arrow  ">>"
#define cc_prompt ">!"
#define cc_null   ">N"
#define cc_eof    ">F"
#define cc_error  ">E"
#define cc_busy   ">B"

// main command grouping
#define cmd_m     'M'
#define cmd_c     'C'
#define cmd_f     'F'
#define cmd_r     'R'
#define cmd_rpc   '/'
#define cmd_n     'N'
#define cmd_p     'P'
#define cmd_u     'U'
#define cmd_c     'C'

#define command_mode true
#define data_mode    false

// error messages, generic
#define noerror               0
#define err_notimplemented    1   // command not implemented
#define err_notrecognized     2   // invalid command parameter
#define err_novalidcommand    3   // no valid command found

// error messages, file operations
#define err_filenotopen      10   // could not open file
#define err_not_mounted      11   // error in mounting file
#define err_handle_used      12   // file handle in use
#define err_no_handle        13   // file handle not defined
#define err_directory        14   // error in opening directory
#define err_seek             15   // error in seek

#define err_paramnoxeq       20   // error executing parameter string

#define err_net_timeout      30   // network timout
#define err_net_NTP          31   // error in NTP

// error message text definitions
#define err_0     "no error"
#define err_1     "command not implemented"
#define err_2     "invalid command parameter"
#define err_3     "no valid command found"

#define err_10    "could not open file"
#define err_11    "error in mounting file"
#define err_12    "file handle in use"
#define err_13    "file handle not defined"
#define err_14    "error in opening directory"
#define err_15    "error in seek"
#define err_16    "error"
#define err_17    "error"
#define err_18    "error"
#define err_19    "error"
#define err_20    "cannot execute paramstring"

#define err_21    "error"
#define err_22    "error"
#define err_23    "error"
#define err_24    "error"
#define err_25    "error"
#define err_26    "error"
#define err_27    "error"
#define err_28    "error"
#define err_29    "error"

#define err_30    "network timeout"
#define err_31    "error in NTP"
#define err_32    "error"
#define err_33    "error"
#define err_34    "error"
#define err_35    "error"
#define err_36    "error"
#define err_37    "error"
#define err_38    "error"
#define err_39    "error"


#define msg_welcome "MMEx "
#define msg_version __DATE__

extern int err_num;
extern int last_err;
extern int tmode; 
extern bool upcase;   // global for change of case for text output

void send_prompt();
void welcome();
void do_maindefault();
void send_int(int val);
void send_2int(int val);
void send_error(int val);
void send_status();

#endif