/* MMEx for MBED - MBED specific command processing
 * Copyright (c) 2011 MK
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/**
  \file mfuncs.h
  \brief Commands starting with M for MBED features
*/

#ifndef MFUNCS_H
#define MFUNCS_H

#include "mmex.h"

// definition of the M-functions
#define mled     'L'         // control LED's
#define mversion 'V'         // get version string
#define mwelcome 'W'         // get welcome string
#define mstatus  'S'         // get MMex status
#define mdebug   'D'         // control DEBUG level
#define merror   'E'         // get latest error message
#define mbaud    'B'         // set console baud rate
#define mcase    'C'         // set case of text output
#define mtime    'T'         // set/get mbed RTC value
#define mreset   'R'         // MBed warm restart

#define ledon    '1'         // value for LED ON
#define ledoff   '0'         // value for LED ON
#define ledtog   'T'         // value for LED toggle
#define ledread  'R'         // value for LED read

#define ucase    'U'         // value for Upper Case
#define nocase   'N'         // value for no change to case

void parse_M();
void do_mled(); 
void do_mversion();
void do_mwelcome();
void do_mstatus();
void do_mdebug();
void do_merror(); 
void do_mreset();
void do_mbaud();
void do_mcase();
void do_mtime();
void do_mdefault();

#endif