/* MMEx for MBED - global declarations of MBED classes
 * Copyright (c) 2011 MK
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 */

/**
  \file mbeddefs.h
  \brief global declarations of some MBED classes
*/

#ifndef MBEDDEFS_H
#define MBEDDEFS_H

#include "mmex.h"
#include "spissp.h"

extern Serial pc;                  // tx, rx
extern DigitalOut _led1;
extern DigitalOut _led2;
extern DigitalOut _led3;
extern DigitalOut _led4;
extern DigitalIn  mldlp09;
extern DigitalIn  mldlp10;
extern spislirq mldl;

/** reset the MBED module
 *
 */
extern "C" void mbed_reset(); 


#endif