/* MMEx for MBED - Network Command processing
 * Copyright (c) 2011 MK
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/**
  \file nfuncs.h
  \brief Commands starting with N for Networking commands
*/

#ifndef NFUNCS_H
#define NFUNCS_H

#include "mmex.h"

// definition of the N-functions for Network
#define ninit    'I'         // Initialize network
#define nstop    'S'         // Stop Network
#define ntime    'T'         // Get time through NTP server
#define nget     'G'         // Get file data
#define nhttp    'H'         // HTTP Server commands

#define MMEx_Hostname "MMEx"

/**
 *  Global variable to enable/disable the HTTP-Server
 */
extern bool network_enabled;

/**
 *  Global variable to indicate if HTTP Server is running
 */
extern bool httpserver_enabled; 

/**
 *  Poll the network (must be called periodically while server is active)
 */
void netpoll();

void parse_N();
void do_ninit();
void do_nstop();
void do_ntime();
void do_nget();
void do_nhttp();
void do_ndefault();

#endif