/* MMEx for MBED - MMEx specific functions
 * Copyright (c) 2011 MK
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/**
  \file mmex.cpp
  \brief MMEx specific functions
*/

#include "mmex.h"

char inbuf[bufsize];                     
char outbuf[bufsize];

int rx_max = 0;
int tx_max = 0;

int err_num = 0;       // global error number
int last_err = 0;
bool upcase = false;   // global for change of case for text output

const char *err_text[] = { 
  err_0,  err_1,  err_2,  NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   NULL,
  err_10, err_11, err_12, err_13, err_14, err_15, err_16, err_17, err_18, err_19,
  err_20, err_21, err_22, err_23, err_24, err_25, err_26, err_27, err_28, err_29, 
  err_30, err_31, err_32, err_33, err_34, err_35, err_36, err_37, err_38, err_39 } ;

/** send the MMEx prompt sequence
 *
 */  
void send_prompt() {
  mldl.tx_add(c_escape);
  mldl.tx_add(c_prompt);
}

/** send the MMEx welcome message
 *
 */  
void welcome() {
  DBG_msg("MMEx welcome", msg_welcome msg_version);
  char str[] = msg_welcome msg_version; 
  upstring(str);
  mldl.tx_string(str);
}

/** send the actual MMEx status
 *
 */  
void send_status() {
  char str[] = "MMEx running";
  upstring(str);
  mldl.tx_string(str); 
}

/** send error message, command not recognized
 *
 */
void do_maindefault() {
  // command not recognized
  DBG_msg("main", "parameter not recognized");
  send_error(err_notrecognized);
}

/** send an integer value to the SPI interface
 *
 *  @param val value to be sent
 *
 */  
void send_int(int val) {
  sprintf(outbuf, "%d", val);
  mldl.tx_string(outbuf);
}

/** send a 2-digit integer value to the SPI interface
 *
 *  @param val value to be sent
 *
 */  
void send_2int(int val) {
  sprintf(outbuf, "%02d", val);
  mldl.tx_string(outbuf);
}

/** global error message processing, send error sequence
 *  and prepare message string
 *
 *  @param val error value
 *
 */ 
void send_error(int val) {
  char str[20];
  sprintf(str, "%02d", val); 
  err_num = val;
  last_err = val;
  DBG_msg("error found: ", str);
  sprintf(str, "%02d:", err_num);
  param[par_E_].assign(str);
  param[par_E_] += err_text[err_num];
  mldl.tx_add(c_escape);
  mldl.tx_add(c_error);
}
 
 