/* MMEx for MBED - Main function
 * Copyright (c) 2011 MK
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 */

/**
  \file main.cpp
  \brief main function for the MMEx application
*/

#include "mmex.h"
#include "mbed.h"

/** read data from the commandline until a <CR> is found
 *
 *  @return returns the number of characters read (including the <CR>)
 */
int readin() {
  int i = 0;
  bool go = true;
  unsigned char inp;

  while (go) {                  // as long as we can continue          
    inp = mldl.rxx_read(command_mode);    // read data with protocol    
    switch (inp) {
      case NULL : break;         // do nothing, read next value
      case c_cr : inbuf[i] = NULL;  //terminate string
                  go = false;
                  break;
      default:    inbuf[i] = inp;
                  i++;
                  break;
    }  // switch
    if(i >= bufsize) {               // command is too long!
      // add proper error handling
      go = false;
      inbuf[i] = NULL;          // terminate string 
    }
  }  
  return i;
}

/** MMEx main function, never returns
 *
 */
int main() {
  int numin;
  
  init_handles();
  
  pc.baud(start_baud);
    
  mldl.init();                // initialize spi
  mldl.DBG_set(DBG_ON);
  
  welcome();                 // send welcome message
  
  init_loadp();              // auto load PARAM_A.TXT
  init_xeq();                // auto execute parameter X
  
  while(1) {
    // main loop for parsing commands
    send_prompt();   
    DBG_msg("main", "send prompt");            
    
    // remove comments below for more extended debugging
    // DBG_int("rx_room", mldl.rx_room());
    // DBG_int("tx_room", mldl.tx_room());
    // DBG_int("rx_empty", mldl.rx_empty());
    // DBG_int("rx_full", mldl.rx_full());
    // DBG_int("tx_empty", mldl.tx_empty());
    // DBG_int("tx_full", mldl.tx_full());        

    numin = readin();     // read input command, must end with <CR>      
    // we are interpreting commands, string is in inbuf[]    
    if (inbuf[0] != NULL) { 
      DBG_msg("main", inbuf);
      switch (inbuf[0]) {
        case cmd_f : param[par_C_].assign(inbuf);
                     parse_F();        // File functions                     
                     break;      
        case cmd_m : param[par_C_].assign(inbuf);
                     parse_M();        // MBed functions
                     break;
        case cmd_p : parse_P();        // Parameter functions
                     break;
        case cmd_rpc : 
        case cmd_r:  param[par_C_].assign(inbuf);
                     parse_R();        // RPC functions
                     break;
        case cmd_n : param[par_C_].assign(inbuf);
                     parse_N();        // Network functions
                     break;
        case cmd_u : param[par_C_].assign(inbuf);
                     parse_U();        // User functions
                     break;
        case cmd_c : param[par_C_].assign(inbuf);
                     parse_C();        // User functions
                     break;
                
        default  :   DBG_msg("do_maindefault", inbuf);
                     do_maindefault(); // first char not recognized
                     break;
      }
    }
  }
}