/* MMEx for MBED - Debug messages
 * Copyright (c) 2011 MK
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/**
  \file debug.cpp
  \brief Functions for generating console debug messages
*/

#include "debug.h"

/** DBG_level
 *
 *  @brief global variable for level of debug messages
 */
int DBG_level = DBG_ON;

/** show a debug message with two strings
 *
 *  @param src this will typically be the name of the function
 *  @param msg message specific information
 */
void DBG_msg(char* src, char *msg) {
  if (DBG_level != DBG_OFF) {
    printf("%s :: %s\n", src, msg);
  } 
}

/** show a debug message with a string and an integer
 *
 *  @param src this will typically be the name of the function
 *  @param i integer passed
 */
void DBG_int(char* src, int i) {
  // prints a single integer as debug message
  if (DBG_level != DBG_OFF) {
    printf("%s : %d\n", src, i);
  }
} 

/** show a debug message with a string and a character both a character and hex value
 *
 *  @param src this will typically be the name of the function
 *  @param c character to be shown
 */
void DBG_chr(char* src, char c) {
  if (DBG_level != DBG_OFF) {
    int cc = c;
    if (c < 32) c = '.';
    printf("%s : %c [%02x]\n", src, c, cc);
  }
} 

/** show one character in hex, input from SPI to the MBED
 *
 *  @param c input to be shown
 */
void DBG_inchar(char C) {
  // prints only one char in hex, preceded by a + for input followed by a space
  if (DBG_level == DBG_FULL) {
    printf("+%02x ", C);
  }
}

/** show one character in hex, output from MBED to SPI
 *
 *  @param c output to be shown
 */
void DBG_outchar(char C) {
  if (DBG_level == DBG_FULL) {
    printf("-%02x ", C);
  }
}