/* MMEx for MBED - RPC Command processing
 * Copyright (c) 2011 MK
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/**
  \file rfuncs.cpp
  \brief Commands starting with R or / for processing RPC
*/

#include "rfuncs.h"

/** main entry for parsing R- or /-commands
 *
 */ 
void parse_R() {
  DBG_msg("parse_R", inbuf);
  err_num = noerror;

  if (inbuf[1] != NULL) {
    switch (inbuf[1]) {
      case rslash  : do_rslash();
                     break;
      case rresult : do_rresult();
                     break;
      case rxeq    : do_rxeq();
                     break;            
      default      : do_rdefault();    // command not recognized
                     break;
    }
  } else { do_rdefault(); }
}

/** Define the value of the PC command string
 *
 *  syntax:  R/[string]      define new RPX command (same as //)
 *  \n  or: R/>+[string]    appends to existing RPC string
 *
 */   
void do_rslash() {   
  DBG_msg("do_rslash", inbuf);
  
  while (inbuf[2] == c_space) remchar(inbuf, 2, 1);  // remove leading space
  remchar(inbuf, 0, 1);                  // remove the R of 1st slash
  
  // now retrieve string from the command line, i starts at 3

  // if first chars are not ">+" the string will be new
  if ((inbuf[3] == c_escape) && (inbuf[4] == c_append)) {      
    // string is append, >+ from inbuf
    remchar(inbuf, 1, 2);
    DBG_msg("append RPC cmd", inbuf);
    param[par_R_].append(inbuf);    
  } else {    
    DBG_msg("new RPC cmd ", inbuf);
    param[par_R_].assign(inbuf);      // no append, assign string
  }    
}

/** Return the result of the previous RPC operation
 *
 *  syntax:  RR or /R
 */ 
void do_rresult() {
  char * cstr;
  
  DBG_msg("do_rresult", inbuf);
  cstr = new char [param[par_S_].size() + 1];
  strcpy(cstr, param[par_S_].c_str());
  DBG_msg("RPC result", cstr); 
  upstring(cstr);
  mldl.tx_string(cstr);  
  delete[] cstr;
}

/** Execute the current RPC string
 *
 *  syntax:  RX or /X
 */
void do_rxeq() {
  char outbuf[256];
  char * cstr;
      
  DBG_msg("do_rxeq", inbuf);
  
  cstr = new char [param[par_R_].size() + 1];
  strcpy(cstr, param[par_R_].c_str());
  DBG_msg("RPC execute", cstr);    

  rpc(cstr, outbuf);                // do the RPC
  delete[] cstr;
  
  DBG_msg("RPC result", outbuf);  
  param[par_S_].assign(outbuf);     // store result
}

/** send error message, command not recognized
 *
 */    
void do_rdefault() {
  DBG_msg("do_rdefault", inbuf);
  send_error(err_notrecognized); 
}