/* MMEx for MBED - Parameter Command processing
 * Copyright (c) 2011 MK
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/**
  \file pfuncs.h
  \brief Commands starting with P for processing Parameters
*/

#ifndef PFUNCS_H
#define PFUNCS_H

#include "mmex.h"
#include <string>        // allow use of string classes

// definition of the P-functions
#define pclear   'C'         // Clear Parameter
#define pset     'S'         // Set Parameter to value
#define pget     'G'         // Get Parameter
#define plen     'L'         // return the length of the parameter string
#define psave    'V'         // Save all parameters to LocalDisk
#define pread    'R'         // Read all parameters from LocalDisk
#define pxeq     'X'         // Execute parameter string as command

// definitions for the user defined parameters
#define par_0    '0'         // 0, user parameter
#define par_1    '1'         // 1, user parameter
#define par_2    '2'         // 2, user parameter
#define par_3    '3'         // 3, user parameter
#define par_4    '4'         // 4, user parameter
#define par_5    '5'         // 5, user parameter
#define par_6    '6'         // 6, user parameter
#define par_7    '7'         // 7, user parameter
#define par_8    '8'         // 8, user parameter
#define par_9    '9'         // 9, user parameter

// other parameters predefined
#define par_E    'E'         // (10) E: most recent Error message
#define par_R    'R'         // (11) R: RPC Command string
#define par_S    'S'         // (12) S: RPC Result string
#define par_C    'C'         // (13) C: Most recent MMEx command
#define par_X    'X'         // (14) X: Auto execute command string

// Networking parameters
#define par_I    'I'         // (15) I: Network IP Address
#define par_J    'J'         // (16) J: Network IP Address when no DHCP
#define par_H    'H'         // (17) H: Network Host name
#define par_M    'M'         // (18) M: Network MAC hardware address
#define par_U    'U'         // (19) U: Network URL
#define par_N    'N'         // (20) N: Networkl User name
#define par_P    'P'         // (21) P: Network Password

#define par_E_   10          // (10) E: most recent Error message
#define par_R_   11          // (11) R: RPC Command string
#define par_S_   12          // (12) S: RPC Result string
#define par_C_   13          // (13) C: Most recent command string
#define par_X_   14          // (14) X: Auto execute command string

#define par_I_   15          // (15) I: Network IP Address
#define par_J_   16          // (16) J: Network IP Address when no DHCP
#define par_H_   17          // (17) H: Network Host name
#define par_M_   18          // (18) M: Network MAC hardware address
#define par_U_   19          // (19) U: Network URL
#define par_N_   20          // (20) N: Networkl User name
#define par_P_   21          // (21) P: Network Password


#define maxparams 21          // number of last parameter

extern string param[maxparams + 1];  // our array of parameter strings

int getpnum(char C);
void parse_P();
void do_pclear(); 
void do_pset();
void do_pget();
void do_plen();
void do_psave();
void do_pread();
void do_pxeq();
void init_loadp();  
void init_xeq();
void do_pdefault();

#endif