/* MMEx for MBED - Support functions
 * Copyright (c) 2011 MK
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/**
  \file helper.cpp
  \brief various support functions for the MMEx
*/

#include "helper.h"

/** remove all spaces from a string
 *
 *  @param src the string to be modified
 *
 */  
void wipesp(char *src) {
  // remove all spaces from a string
  char *dst = src;

  while (*src != 0) {
    if (*src != c_space) {
      *dst++ = *src; // copy
    }
    src++;
  }
  *dst = 0;
}  

/** remove part of a string
 *
 *  @param src the string to be modified
 *  pos start position for removing characters
 *  len number of characters to remove
 *
 */ 
void remchar(char *src, int pos, int len) {
  char *dst = src;
  int i = 0;
  
  if (pos < 0) return;
  if (len < 0) return;
  
  src += pos;
  dst = src;
  src += len; 
  for ( i = pos + 1; *src != 0; i++ ) *dst++ = *src++;  
  *dst = 0;  // Ensure the string is null-terminated. 
}
 
/** convert a hex char '0' to 'F' in its decimal equivalent
 *
 *  @param C character
 *  @return a value 0 to 15, 0 when C was not in '0'..'F'
 *
 */  
int hex2int(char C) {
  if ((C >= '0') && (C <= '9')) return(C - '0');
  if ((C >= 'A') && (C <= 'F')) return(C - 'A' + 10);
  return(0);
}
 
/** insert a string in another string
 *
 *  @param str1 target string where insert takes place in
 *  @param str2 string to be inserted
 *  @param pos position of insertion
 *
 */              
void insertstr(char *str1, char *str2, int pos) {
  int i;
  int sz1 = 0;  // size of str1
  int sz2 = 0;  // size of str2
  char *dst = str1;  // save start of str1
  char *end = str1;  // end of str1
     
  for (i = 0; str1[i] != 0; i++) sz1++;  // length of string1
  for (i = 0; str2[i] != 0; i++) sz2++;  // length of string2
  
  str1 += pos;        // insert point
  end  += sz1;        // end of string 1
  dst  += sz1 + sz2;  // end of new string
  
  // now move the end of str1 to make room
  for (i = 0; i <= sz2; i++) *dst-- = *end--;
    
  // and move str2 in the free space inside str1
  for (i = 0; i < sz2; i++) *str1++ = *str2++;  
}

/** convert a string to upper case if global variable upcase is true
 *
 *  @param str string to modify
 */  
void upstring(char * str) {
  if (upcase) {  
    while (*str != NULL) {    
      if ((*str >= 'a') && (*str <= 'z')) *str = *str - 0x20;       
      str++;    
    }  
  }    
}     
      
      
