/* MMEx for MBED - Support functions
 * Copyright (c) 2011 MK
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/**
  \file globaldefs.h.h
  \brief header file for some global definitions
*/

#ifndef GLOBALDEFS_H
#define GLOBALDEFS_H

// control characters
#define c_prompt  '!'            // prompt character
#define c_escape  '>'            // escape character
#define c_arrow   '>'            // to send the > character
#define c_eof     'F'            // for End-Of-File/End-Of-Transmission
#define c_return  'C'            // for Cariiage Return
#define c_null    'N'            // for null character
#define c_zero    '0'            // alternative for null
#define c_hex     '$'            // hex chars to follow
#define c_hexalt  'X'            // hex chars to follow
#define c_append  '+'            // append to string
#define c_intrpt  'I'            // interrupt pending command
#define c_space   ' '            // space character
#define c_cr      0x0d           // Carriage Return or <CR>
#define c_percent '%'            // percent character

#define c_error   'E'
#define c_busy    'B'

#define c_rpc     '/'
#define c_rpcapp  '+'
#define c_rpcexe  '*'

// control strings
#define cc_arrow  ">>"
#define cc_prompt ">!"
#define cc_null   ">N"
#define cc_eof    ">F"
#define cc_error  ">E"
#define cc_busy   ">B"

// main command grouping
#define cmd_m     'M'
#define cmd_c     'C'
#define cmd_f     'F'
#define cmd_r     'R'
#define cmd_rpc   '/'
#define cmd_n     'N'
#define cmd_p     'P'
#define cmd_u     'U'
#define cmd_c     'C'

#define command_mode true
#define data_mode    false


#endif