/* MMEx for MBED - File I/O Command processing
 * Copyright (c) 2011 MK
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/**
  \file ffuncs.h
  \brief header file for ffuncs
*/

#ifndef FFUNCS_H
#define FFUNCS_H

#include "mmex.h"

// definition of the F-functions
#define fmount   'M'         // mount filesystem
#define funmount 'U'         // Unmount filesystem
#define ffopen   'O'         // File Open
#define ffread   'R'         // File Read
#define ffwrite  'W'         // File Write
#define ffclose  'C'         // File Close
#define ffseek   'S'         // File Seek
#define fflush   'F'         // File Flush
#define fdir     'D'         // Directory listing first entry
#define fndir    'N'         // Directory listing next entry
#define fftell   'T'         // Get value of file pointer
#define ffsize   'Z'         // Get size of file

#define f_sdcard 'S'         // SD card is the medium
#define f_usb    'U'         // USB stick is the storage medium
#define f_local  'L'         // local flash is the storage medium

#define f_modew  'w'         // file mode is write
#define f_moder  'r'         // file mode is read
#define f_modea  'a'         // file mode is append

#define fs_local "local"     // name for local filesystem
#define fs_sd    "sd"        // name for SD card filesystem
#define fs_usb   "usb"       // name for USB filesystem

#define fsp_local "/local/"  // path name for local filesystem
#define fsp_sd    "/sd/"     // path name for SD card filesystem
#define fsp_usb   "/usb/"    // path name for USB filesystem

#define rt_local "/local"    // root path name for local filesystem
#define rt_sd    "/sd"       // root path name for SD card filesystem
#define rt_usb   "/usb"      // root path name for USB filesystem

struct fhandle {             // used for saving info in file handles
         char filename[20];  // filename
         char medium;        // S, U or F
         char fsp[10];       // path name, root only
         char direct[20];    // string with current directory
         char filemode;      // current filemode
         char fullpath[50];  // full path
         FILE *fp;           // file pointer
       }; 

void init_handles();
void parse_F();

void do_fmount(); 
void do_funmount();
void do_ffopen();
void do_ffread();
void do_ffwrite();
void do_ffclose();
void do_ffseek();
void do_fflush(); 
void do_fdir();
void do_fndir();
void do_fftell();
void do_ffsize();
void do_fdefault();

#endif