/**
 * IR Blaster driver
 * 
 * please see Dream-IV User manual for more detail information.
 *
 ****/

/*
 * UART Packet Structure
    
    ------------------------------------------------
    | SOP | Payload Size | Command | Payload | EOP |
    | (1) |     (1)      |   (1)   | (0~128) | (1) |
    ------------------------------------------------
*/
 
#define SOP 0xFE   //start of frame
#define EOP 0xEF   //end of frame
 
#define COMMAND_GET_VERSION     0x00
#define COMMAND_START_IROUT     0x01
#define COMMAND_STOP_IROUT      0x02

// Response Command = 0x80 | Command
/*  -----------------------------------------------------------
    | SOP | Payload Size | 0x80 | Command | Payload   |   EOP |
    | 0xFE|     1byte    |   (1)          | (reponse) |  0xEF |
    -----------------------------------------------------------
*/

#define RSP_ACK     0x00
#define RSP_INVALID_PACKET      0x10
#define RSP_INVALID_COMMAND     0x10
#define RSP_INVALID_FORMATID    0x10

// Format Types
#define NEC         0x01
#define NEC_SR      0x02  //NEC simple repeate
#define TOSHIBA     0x03
#define TOSHIBA_SR  0x04 // Toshiba simple repeate
#define PHILIPS_RC5 0x05
#define SONY_12BITS 0x06
#define SONY_15BITS 0x07
#define SONY_20BITS 0x08
#define MISUBISHI   0x09
#define JVC         0x0A






