#include "mbed.h"
#include "IR_Blaster.h"

Serial pc(SERIAL_TX, SERIAL_RX);
Serial IrBlaster(PA_9, PA_10);

#define MAX_BUF_SIZE 12
#define PAYLOAD_LEN  8

char IrTxBuffer[MAX_BUF_SIZE] = {0,};

/*
 * UART Packet Structure
    
    ------------------------------------------------
    | SOP | Payload Size | Command | Payload | EOP |
    | (1) |     (1)      |   (1)   | (0~128) | (1) |
    ------------------------------------------------
 *
 */

// Sample UART data structure when user data is "0x6A"
// NEC custom code : 0x04,0xFB
char NEC_SR_Sample[12] =    {0xFE,0x8,0x1, 0x01,0x04,0xFB,0x00,0x00,0x6A,0x00,0x00, 0xEF};
char NEC_Sample[12]    =    {0xFE,0x8,0x1, 0x02,0x04,0xFB,0x00,0x00,0x6A,0x00,0x00, 0xEF};
// TOSHIBA custom code : 0x07, 0x07
char TOSHIBA_Sample[12]=    {0xFE,0x8,0x1, 0x03,0x07,0x07,0x00,0x00,0x6A,0x00,0x00, 0xEF};
char TOSHIBA_SR_Sample[12]= {0xFE,0x8,0x1, 0x04,0x07,0x07,0x00,0x00,0x6A,0x00,0x00, 0xEF};
// PHILIPS System code : 0x15    
char PHILIPS_RC5_Sample[12]={0xFE,0x8,0x1, 0x05,0x15,0x00,0x00,0x00,0x6A,0x00,0x00, 0xEF};     
// SONY custom code : 0x12
char SONY_12BITS_Sample[12]={0xFE,0x8,0x1, 0x06,0x12,0x00,0x00,0x00,0x6A,0x00,0x00, 0xEF};     
char SONY_16BITS_Sample[12]={0xFE,0x8,0x1, 0x07,0x42,0x00,0x00,0x00,0x6A,0x00,0x00, 0xEF};     
char SONY_20BITS_Sample[12]={0xFE,0x8,0x1, 0x08,0x34,0x00,0x00,0x00,0x6A,0x00,0x00, 0xEF};     
char MISUBISHI_Sample[12]=  {0xFE,0x8,0x1, 0x09,0x12,0x00,0x00,0x00,0x6A,0x00,0x00, 0xEF};   
char JVC_Sample[12]=        {0xFE,0x8,0x1, 0x0A,0x12,0x00,0x00,0x00,0x6A,0x00,0x00, 0xEF}; 


DigitalOut myled(LED1);
 
int main() {
  int i = 1;
  int j = 0;
  
  pc.baud(115200);
  IrBlaster.baud(115200);
  IrBlaster.format(8, Serial::None, 1);

  IrBlaster.printf("Hello World !\n");
  while(1)
  {
    wait(2);
    //Send IR data through UART to IR Blaster 
    IrTxBuffer[0]  = SOP;
    IrTxBuffer[1]  = PAYLOAD_LEN;
    IrTxBuffer[2]  = COMMAND_START_IROUT;
    IrTxBuffer[3]  = NEC;
    IrTxBuffer[4]  = 0x04;
    IrTxBuffer[5]  = 0xFB;
    IrTxBuffer[8]  = 0x6A;
    IrTxBuffer[11] = EOP;
    for(j=0; j<12; j++)
        IrBlaster.putc(IrTxBuffer[j]);
    pc.printf("This program runs since %d seconds.\n", i++);
    myled = !myled;
   }

}
 