/* PCA9675 Device Driver C++ Example */
/* ********************************* */

#include "mbed.h"
#include "misra_types.h"                         /* MISRA Types */
#include "PCA9675.h"


#define PCA9675_BASE_BOARD_SLAVE_ADDRESS 0x20


/* I2C Interface */
/* Create a master I2C bus called CNTRL_i2C using pins 9 and 10 for SDA, & SCL  respectively */
/* This I2C bus can be used fr many peripherals and not just the PCA9675 */
I2C CNTRL_i2c(p9, p10);                         

/* Configure the USB as a virtual communications port */
Serial pc(USBTX, USBRX);

/* Create a global object of PCA96755 class called BaseBoardLatch */
/* this device will use CNTRL_i2c bus and has a slave address of PCA9675_BASE_BOARD_SLAVE_ADDRESS*/
PCA9675 BaseBoardLatch(&CNTRL_i2c, PCA9675_BASE_BOARD_SLAVE_ADDRESS);       
                                                                            

int main() 
    {
        uint8_t port0_payload = 0;
        uint8_t port1_payload = 0;
        uint8_t manufacturer = 0;
        uint16_t part_ident = 0;
        uint8_t die_revision = 0;
        uint8_t MySlaveAddress = 0;
        sint32_t Ack_Status = 0;

        pc.baud(115000);                        /* Baud rate should be 115k baud */
        pc.format(8,Serial::None,1);            /* format is 8 data bits, no stop bit, no parity */
        pc.printf("\n\n\n\n\n\n\n\rWelcome to the I2C PCA9675 Driver Test Routines for mbed\n\r\n");
        
        CNTRL_i2c.frequency(400000);           /* Set the I2C to be 400kHz */
        
        /* Read the PCA9575 device ID */
        pc.printf("Reading the device ID\n\r");
        Ack_Status = BaseBoardLatch.read_device_ID(&manufacturer, &part_ident, &die_revision);
        pc.printf("Read ID: Ack status = ");
        if (Ack_Status ==  BaseBoardLatch.eI2C_ACK) pc.printf("ACK\n\r");
        else pc.printf ("NACK\n\r");
        pc.printf("The stored identification for this device is:\n\r");
        pc.printf("  * Manufacturer Code = 0x%.2x\n\r",  manufacturer); 
        pc.printf("  * Part Idenfification = 0x%.4x\n\r", part_ident);
        pc.printf("  * Die Revision = 0x%.1x\n\r", die_revision);
        

        /* Use this code for output */

        /* Setup the I/O direction : for each bit 1=input and 0=output */
        /* Order is Port0 and Port1 */
        pc.printf("\nSetting the device for quasi output mode\n\r");
        Ack_Status = BaseBoardLatch.init(0x00, 0x00);             
        pc.printf("Initialise: Ack status = ");
        if (Ack_Status == BaseBoardLatch.eI2C_ACK) pc.printf("ACK\n\r");
        else pc.printf ("NACK\n\r");
        
        pc.printf("Writing data to the latch\n\r");
        Ack_Status = BaseBoardLatch.write_data(port0_payload, port1_payload);       /* Write two bytes of data to the device */
        pc.printf("Write data: Ack status = ");
        if (Ack_Status == BaseBoardLatch.eI2C_ACK) pc.printf("ACK\n\r");
        else pc.printf ("NACK\n\r");
   
                
        /* Use this code for input */
        
        /* Setup the I/O direction : for each bit 1=input and 0=output */
        /* Order is Port0 and Port1 */
        pc.printf("\nSetting the device for quasi input mode\n\r");
        Ack_Status = BaseBoardLatch.init(0xff, 0xff);
        pc.printf("Initialise: Ack status = ");
        if (Ack_Status == BaseBoardLatch.eI2C_ACK) pc.printf("ACK\n\r");
        else pc.printf ("NACK\n\r");
        
        Ack_Status = BaseBoardLatch.read_data(&port0_payload, &port1_payload);       /* Read two bytes from the device */
        pc.printf("Read data: Ack status = ", Ack_Status);
        if (Ack_Status == BaseBoardLatch.eI2C_ACK) pc.printf("ACK\n\r");
        else pc.printf ("NACK\n\r");
        pc.printf("Port0 = 0x%.2x, Port1 = 0x%.2x\n\r", port0_payload, port1_payload);

        
        /* Read back the slave address of the PCA9675 object if we need to recall it */
        MySlaveAddress = BaseBoardLatch.read_slave_address();
        pc.printf("\nThe 7 bit Slave address: is = 0x%.2x\n\r", MySlaveAddress);

}
