#include "mbed.h"

#ifndef PCA9675__
#define PCA9675__
#endif

/* Define a class for PCA9675 */
class PCA9675
    {
        /* Private members first */
        private:
            uint8_t My_Lcoal_Slave_Address;
            uint8_t My_Local_Port0_Direction;
            uint8_t My_Local_Port1_Direction;
            sint32_t reset();                                                                       /* Reset the device using a general call */
            I2C *My_Local_I2C;                                                                      /* make use of the existing I2C class for i2C calls */
            
        /* Public members next */
        public: 
            PCA9675(I2C *Selected_I2C_Channel, uint8_t Slave_Address);                              /* Constructor - create with the slave address */
            ~PCA9675();                                                                             /* Destructor */
            sint32_t init(uint8_t port0_Direction, uint8_t port1_Direction);                        /* Reset the device and setup the IO direction */
            sint32_t write_data(uint8_t port0_payload, uint8_t port1_payload);                      /* Write two bytes of data to the device */
            sint32_t read_data(uint8_t *read_port0, uint8_t *read_port1);                           /* Read two bytes from the device */
            sint32_t read_device_ID(uint8_t *manufacturer, uint16_t *part_ident, uint8_t *die_revision);
            uint8_t read_slave_address();                                                           /* Read the configured slave address */


            enum PCA9675_Defines
                {
                eI2C_ACK = 0,
                ePCA9675_RESET_COMMAND = 6,
                ePCA9675_RESET_ADDRESS = 0,
                ePCA9675_PORT0 = 0,
                ePCA9675_PORT1 = 1,
                eI2C_REPEATED_START = 1,
                eI2C_NO_REPEATED_START = 0                
                };


    };
        




