/* SD-Card Utility Program for RS-EDP and RS-EDP mbed adapter module */
/* ***************************************************************** */

/* This application will create a file and write a few bytes to the SD Card on the mbed adapter board */


#include "mbed.h"

#include "defines.h"
#include "misra_types.h"
#include "mbed_Port_Structure.h"

#include "SDFileSystem.h"




/* Main Loop Here */
int main(void) 
    {
        FILE *MyNewFile;
        char file_name_with_root_and_path[30];
        char input_file_name[30];
        char *pointer1;
        char *pointer2;
        char n = 0;


        for (n = 0; n < 30; n++)                                                       /* initialise arrays to zero */
            {
                file_name_with_root_and_path[n] = 0;    
                input_file_name[n] = 0;
            }
            
        setup_mbed_ports();                                                            /* Setup the I/O Structure of the mbed module */

        pc.printf("\n\n\n\n\n\n\n\rWelcome the the RS-EDP platform\n\r");
        pc.printf("This software is for the MBED - LPC1768 Module\n\r");
        pc.printf("This software exercises the on board SD-CARD card via an SPI interface\n\r");
        pc.printf("The SD card slot is present on the reverse side of the MBED adapter board\n\r");        
        pc.printf("\nSoftware Revision Number: %03d\n\r\n", FIRMWARE_VERSION);
        
        pc.printf("This application writes a few bytes to a txt file on the SD-CARD\n\r"); 
        pc.printf("Make sure the LOCAL ECHO on your terminal emulator is turned ON\n\r"); 
          
        User_Led1 = LED_OFF;
        User_Led2 = LED_OFF;
        User_Led3 = LED_OFF;
        User_Led4 = LED_OFF;    
        
        while(1)
            {            

                pointer1 = file_name_with_root_and_path;                                  /* set pointer1 to point at the complete name and path array */
                strcpy(pointer1, "/sd/");                                                 /* Start to build the root, directory and file name of the file we want to create */
       
                pointer2 = input_file_name;                                               /* set pointer2 to point at an empty string array to take the user input file name */
                pc.printf("Enter the file name you wish to create\n\r\n");

                scanf("%s", pointer2);                                                    /* Get the file name into an array called 'input_file_name', pointed to by a pointer called pointer2 */
                strcat(pointer1, pointer2);                                               /* Add on the entered file name to the root direcotry, and store in pointer1 */


                pc.printf("Creating the file: %s\n\r", file_name_with_root_and_path);     /* Print the name including the root and path of the file */

                MyNewFile = fopen(file_name_with_root_and_path, "w");                     /* attempt to open/create the file */


                if (MyNewFile == 0 ) 
                    {
                        /* Problems - can not create the file whos name we just inputed */
                        pc.printf("Unable to create the file '%s'\n\r", file_name_with_root_and_path);
                        pc.printf("Please try again\n\n\r");                    
                    }
                else{
                        /* ok file is now open - lets print the header file */
                        pc.printf("Writing to the file...\n\r");                    
                        fprintf(MyNewFile, "This text string has just been written to your file");
                        pc.printf("Finished writing to the file...\n\n\r");                    
                        fclose(MyNewFile);                                                  /* Close the file */
                    }
            }
      }
  
