/* Wav File Support */
/* **************** */

#include "mbed.h"
#include "defines.h"
#include "misra_types.h"
#include "mbed_Port_Structure.h"



/* Function Prototypes */
uint8_t wave_file_check(uint8_t *wave_array, FILE *open_file);


/* Global Variables */
struct wave_header_construction
				{	sint8_t  identification_block[5];
					uint32_t length_of_file;
					sint8_t  identifier1[5];
					sint8_t  identifier2[5];
					uint32_t position_of_data;
					uint16_t format_tag;
					uint16_t number_of_channels;
					uint32_t samples_per_second;					
					uint32_t bytes_per_second;
					uint16_t bytes_per_sample;
					uint16_t bits_per_sample;
					sint8_t  marker[5];
					uint32_t number_of_bits_in_sample;
				} wave_file_info;





/* Wave File Checker */
uint8_t wave_file_check(uint8_t *wave_array, FILE *open_file)
	{
		uint8_t brk_flag = 0u;
		uint8_t x = 0u;
		uint8_t valid_sample = 0u;
		sint16_t ch = 0;
		
		pc.printf("\n\rPrinting out.WAV file header...\n\r");	

		for (x = 0; x < 0x2bu; x++)												/* Read the first 0x2b bytes of the file as this is the haeder informtation relating to sample rate etc. */
			{
				ch = fgetc(open_file);											/* Get the first byte from the file */
				if (ch == EOF)  												/* Check for eof */
					{
						pc.printf("   File too short to be a wave file\n\r");	/* If we have less than 0x2b then file is not a wave file. */
						valid_sample = 0u;
						brk_flag = 1u;
					}
				else{
						wave_array[x] = ch;	   									/* Load data in to header file array */
					}
					
				if (brk_flag == 1u) 
					{
						break;
					}
			}
			
		if (brk_flag == 0u) 													/* OK we have downloaded the header into an Array. Lets check to see if its a valid file */
			{
				pc.printf("   Identification block (4 ASCII bytes)= ");								/* First 4 bytes are header block */
				for (x = 0u; x < 4; x++) 
					{
						pc.putc(wave_array[x]);                   									/* and write them on the screen */
						wave_file_info.identification_block[x] = wave_array[x];
					}
				wave_file_info.identification_block[4] = 0;											/* add the string terminator on the end */
				pc.printf(" '%s'\n\r", wave_file_info.identification_block);
	
				
				pc.printf("   Length of file (4 bytes) = ");										/* Length of file. */
				for (x = 4u; x < 8u; x++) 
					{
						pc.printf("%d ",wave_array[x]);
					}
				wave_file_info.length_of_file =  ( ((uint32_t) wave_array[7] << 24) 
												 + ((uint32_t) wave_array[6] << 16) 
												 + ((uint32_t) wave_array[5] << 8) 
												 + ((uint32_t) wave_array[4]) ); 
				pc.printf(" = %d bytes\n\r", wave_file_info.length_of_file);

			
				pc.printf("   Identifier (4 ASCII bytes) = ");										/* indentifier string1 */
				for (x = 8u; x < 12u; x++) 
					{
						pc.putc(wave_array[x]);                   									/* and write them on the screen */
						wave_file_info.identifier1[x-8] = wave_array[x];
					}
				wave_file_info.identification_block[4] = 0;											/* add the string terminator on the end */
				pc.printf(" '%s'\n\r", wave_file_info.identifier1);
	
				
				pc.printf("   Identifier (4 ASCII bytes) = ");										/* Identifier String 2 */
				for (x = 12; x < 16u; x++) 
					{
						pc.putc(wave_array[x]);                   									/* and write them on the screen */
						wave_file_info.identifier2[x-12] = wave_array[x];
					}
				wave_file_info.identifier2[4] = 0;													/* add the string terminator on the end */
				pc.printf(" '%s'\n\r", wave_file_info.identifier2);
						

				pc.printf("   Position of data (4 bytes) = ");										/* Position of data */
				for (x = 16u; x < 20u; x++) 
					{
						pc.printf("%d ",wave_array[x]);
					}
				wave_file_info.position_of_data =  ( ((uint32_t) wave_array[19] << 24) 
												   + ((uint32_t) wave_array[18] << 16) 
												   + ((uint32_t) wave_array[17] << 8) 
												   + ((uint32_t) wave_array[16]) ); 
				pc.printf(" = %d\n\r", wave_file_info.position_of_data);

			
				pc.printf("   Format Tag - Always 1 for Wave PCM (2 bytes) = ");					/* format tag */
				for (x = 20u; x < 22u; x++) 
					{
						pc.printf("%d ",wave_array[x]);
					}
				wave_file_info.format_tag = ( ((uint32_t) wave_array[21] << 8) 
											+ ((uint32_t) wave_array[20]) ); 
				pc.printf(" = %d\n\r", wave_file_info.format_tag);

						
				pc.printf("   Number of channels (2 bytes) = ");									/* Number of channels, mono or steroeo */
				for (x = 22u; x < 24u; x++) 
					{
						pc.printf("%d ",wave_array[x]);
					}
				wave_file_info.number_of_channels = ( ((uint32_t) wave_array[23] << 8) 
													+ ((uint32_t) wave_array[22]) ); 
				pc.printf(" = %d channel(s)\n\r", wave_file_info.number_of_channels);

					
				pc.printf("   Samples per second (4 bytes) = ");		 							/* Samples per second */
				for (x = 24u; x < 28u; x++) 
					{
						pc.printf("%d ",wave_array[x]);
					}
				wave_file_info.samples_per_second =( ((uint32_t) wave_array[27] << 24) 
												   + ((uint32_t) wave_array[26] << 16) 
												   + ((uint32_t) wave_array[25] << 8) 
												   + ((uint32_t) wave_array[24]) ); 
				pc.printf(" = %d samples per sec\n\r", wave_file_info.samples_per_second);

								
				pc.printf("   Bytes Per Second (4 bytes) = ");	 									/* Bytes per second */
				for (x = 28u; x < 32u; x++) 
					{
						pc.printf("%d ",wave_array[x]);
					}
				wave_file_info.bytes_per_second =  ( ((uint32_t) wave_array[31] << 24) 
												   + ((uint32_t) wave_array[30] << 16) 
												   + ((uint32_t) wave_array[29] << 8) 
												   + ((uint32_t) wave_array[28]) ); 
				pc.printf(" = %d bytes per sec\n\r", wave_file_info.bytes_per_second);

			
				pc.printf("   Bytes Per Sample (2 bytes) = ");   									/* Bytes per sample */
				for (x = 32u; x < 34u; x++) 
					{
						pc.printf("%d ",wave_array[x]);
					}
				wave_file_info.bytes_per_sample = 	( ((uint32_t) wave_array[33] << 8) 
													+ ((uint32_t) wave_array[32]) ); 
				pc.printf(" = %d bytes\n\r", wave_file_info.bytes_per_sample);

					
				pc.printf("   Bits Per Sample (2 bytes) = ");										/* Bits per sample */
				for (x = 34u; x < 36u; x++) 
					{
						pc.printf("%d ",wave_array[x]);
					}
				wave_file_info.bits_per_sample = ( ((uint32_t) wave_array[35] << 8) 
													+ ((uint32_t) wave_array[34]) ); 
				pc.printf(" = %d bits\n\r", wave_file_info.bits_per_sample);

						
				pc.printf("   Marker (4 ASCII bytes) = ");											/* Marker */
				for (x = 36u; x < 40u; x++) 
					{
						pc.putc(wave_array[x]);
						wave_file_info.marker[x-36] = wave_array[x];						
					}
				wave_file_info.marker[4] = 0;
				pc.printf(" '%s'\n\r", wave_file_info.marker);
						

				pc.printf("   The number of bits in the sample (4 bytes) = "); 						/* Number of bits per sample. */
				for (x = 40u; x < 44u; x++) 
					{
						pc.printf("%d ",wave_array[x]);
					}
				wave_file_info.number_of_bits_in_sample =  (  ((uint32_t) wave_array[43] << 24) 
												   			+ ((uint32_t) wave_array[42] << 16) 
												   			+ ((uint32_t) wave_array[41] << 8) 
												   			+ ((uint32_t) wave_array[40]) ); 
				pc.printf(" = %d bits\n\r", wave_file_info.number_of_bits_in_sample);
					
			
				/* Check for valid Wave file */
				if (((wave_array[0] == 'R') && (wave_array[1] == 'I') && (wave_array[2] == 'F') && (wave_array[3] == 'F'))
				&&  ((wave_array[8] == 'W') && (wave_array[9] == 'A') && (wave_array[0x0a] == 'V') && (wave_array[0x0b] == 'E'))
				&& ((wave_array[0x0c] == 'f') && (wave_array[0x0d] == 'm') && (wave_array[0x0e] == 't') && (wave_array[0x0f] == ' '))
				&& (wave_array[0x14] == 0x01)) valid_sample = 1u;
				}

		pc.printf("Finished examining the .WAV file header\n\r");
		if (valid_sample == 1)
			{
				pc.printf("Sample is a valid .WAV sample file\n\n\r");
			}
		else{
				pc.printf("Sample is a NOT a valid .WAV sample file\n\n\r");	
			}	

		return valid_sample;
	}
