/* Configure the I/O Port Structure */
/* ******************************** */


/* includes files */
#include "mbed.h"                                /* Header file for mbed module */
#include "defines.h"                            /* User defines */
#include "misra_types.h"                         /* MISRA Types */
#include "SDFileSystem.h"                        /* File System for SD Card */



/* Digital I/O */
DigitalOut User_Led1(LED1);
DigitalOut User_Led2(LED2);
DigitalOut User_Led3(LED3);
DigitalOut User_Led4(LED4);


/* SPI Interface to RS-EDP CNTRL_SPI and the SD Card on Adapter board */
SDFileSystem sd(p11, p12, p13, p14, "sd");


/* Configure the USB as a virtual communications port */
Serial pc(USBTX, USBRX);




/* Function Prototypes */
void setup_mbed_ports(void);



/* Configure the I/O Ports */
void setup_mbed_ports(void)
    {
        pc.baud(115000);                        /* Baud rate should be 115k baud */
          pc.format(8, Serial::None, 1);        /* format is 8 data bits, no stop bit, no parity */

        User_Led1 = LED_ON;
        User_Led2 = LED_OFF;
        User_Led3 = LED_ON;
        User_Led4 = LED_OFF;
    }


