/* SD-Card Utility Program for RS-EDP and RS-EDP mbed adapter module */
/* ***************************************************************** */



#include "mbed.h"

#include "defines.h"
#include "misra_types.h"
#include "mbed_Port_Structure.h"

#include "SDFileSystem.h"
#include "Wav_Support_File.h"




/* Main Loop Here */
int main(void) 
	{
		FILE *wavfile;
		char file_name_with_root_and_path[30];
		char input_file_name[30];
		char *pointer1;
		char *pointer2;
		char n = 0;
		uint8_t wave_array[30];	



		for (n = 0; n < 30; n++)												/* initialise arrays to zero */
			{
				file_name_with_root_and_path[n] = 0;	
				input_file_name[n] = 0;
			}
			
		setup_mbed_ports();														/* Setup the I/O Structure of the mbed module */

		pc.printf("\n\n\n\n\n\n\n\rWelcome the the mbed SD-CARD Utility\n\r");
		pc.printf("Software Revision Number: %d\n\r\n", FIRMWARE_VERSION);
		
		pc.printf("This application reads a .WAV file from the SC-CARD and\n\r"); 
		pc.printf("displays the header information contained within it\n\n\r");

        User_Led1 = LED_OFF;
        User_Led2 = LED_OFF;
        User_Led3 = LED_OFF;
        User_Led4 = LED_OFF;    
        
		while(1)
			{            
        		pointer1 = file_name_with_root_and_path;								/* set pointer1 to point at the complete name and path array */
				strcpy(pointer1, "/sd/");												/* Start to build the root, directory and file name of the file we want to examine */
       
				pointer2 = input_file_name;												/* set pointer2 to point at an empty string array to take the user input file name */
	        	pc.printf("Enter the file name you wish to check\n\r");

    	    	scanf("%s", pointer2);													/* Get the file name into an array called 'input_file_name', pointed to by a pointer called pointer2 */
        		strcat(pointer1, pointer2);												/* Add on the entered file name to the root direcotry */

		        pc.printf("Opening the file: %s\n\r", file_name_with_root_and_path);	/* Print the name including the root and path of the file */
	  			wavfile = fopen(file_name_with_root_and_path,"r");						/* Attempt to open the file for read only*/

				if (wavfile == 0 ) 
					{
    					/* Problems - can not open the file whos name we just inputed */
    					pc.printf("Unable to open wav file '%s'\n\r", file_name_with_root_and_path);
						pc.printf("Please try again\n\r");    				
					}
   				else{
  						/* ok file is now open - lets print the header file */
		  				wave_file_check(wave_array, wavfile);
		  			}
  

				/* you can now access all of the .WAV header file information in a global structure called 'wave_file_info' */
				/* the structure provides you with all the necessary information to manage sample rates and timings etc */
				/* eg */		
				/* sample_rate    = wave_file_info.samples_per_second; */
				/* stereo_or_mono = wave_file_info.number_of_channels  */ 

	  			fclose(wavfile);														/* Close the file */
  			}
  	}
  
