/* Configure the I/O Port Structure */
/* ******************************** */




/* includes files */
#include "mbed.h"                                /* Header file for mbed module */
#include "defines.h"                            /* User defines */
#include "misra_types.h"                         /* MISRA Types */
#include "RSEDP_Slave_Address_Defines.h"        /* Slave address of I2C Devices defined here */



/* Digital I/O */
DigitalOut User_Led1(LED1);
DigitalOut User_Led2(LED2);
DigitalOut User_Led3(LED3);
DigitalOut User_Led4(LED4);


/* SPI Interface to RS-EDP CNTRL_SPI and the SD Card on Adapter board */
SPI CNTRL_spi(p5, p6, p7);                                    /* MOSI, MISO, SCLK */

/* pin 8 used as input */
DigitalIn DigitalIn_Pin8(p8);

/* I2C Interface to RS-EDP CNTRL I2C */
I2C CNTRL_i2c(p9, p10);                                /* SDA, SCL */


/* SPI interface to base board MCI Pins and to LCD pins on the adapter board */
SPI MCI_spi(p11, p12, p13);                                /* MOSI, MISO, SCLK */

/* pin 14 used as digital out */
DigitalOut DigitalOut_Pin14(p14);


/* Analogue I/O Pin Definitions or General I/O */
AnalogIn AD0(p15);
AnalogIn AD1(p16);
AnalogIn AD2(p17);
AnalogIn AD3(p18);

DigitalOut DigitalOut_Pin19(p19);

/* pin 20 not configured */


/* Pin21 used as PWM */
PwmOut PwmOut_Pin21(p21);

/* pin 22  - not configured */
PwmOut PwmOut_Pin23(p23);

/* Pin24 used as PWM */
DigitalOut DigitalOut_Pin24(p24);


/* Serial Interface to RS-EDP ASC1 UART1 */
Serial UART1(p26, p25);                                /* Tx,Rx Serial UART0/ASC0 - secondary UART channel */


/* Serial Interface to RS-EDP ASC0 UART0 */
Serial UART0(p28, p27);                                /* Tx,Rx Serial UART0/ASC0 - primary UART channel */


/* pin 29 - not configured */


/* Pin29 & Pin30 - used as CAN or general I/O */
DigitalIn DigitalIn_Pin30(p30);                        



/* Configure the USB as a virtual communications port */
Serial pc(USBTX, USBRX);




/* Function Prototypes */
void setup_mbed_ports(void);



/* Configure the I/O Ports */
void setup_mbed_ports(void)
    {
        pc.baud(115000);                        /* Baud rate should be 115k baud */
          pc.format(8,Serial::None,1);                        /* format is 8 data bits, no stop bit, no parity */

        User_Led1 = LED_ON;
        User_Led2 = LED_OFF;
        User_Led3 = LED_ON;
        User_Led4 = LED_OFF;
        
        DigitalOut_Pin14 = 0;
        DigitalOut_Pin19 = 1;                    /* if motor drive fitted set brake to ON */
        DigitalOut_Pin24 = 0;
        
        PwmOut_Pin23 = (1.0f);                    /* if motor drive board fitted set PWM duty to zero */

    }





