/* MBED Module - RS-EDP Platform */
/* ***************************** */

#include "mbed.h"
#include "RSEDP_Mbed_Complete.h"




/* Main Loop Here */
int main(void) 
    {
            
        setup_mbed_ports();                                                                            /* Setup the I/O Structure of the mbed module */
        pc.printf("\n\n\n\n\n\n\n\rWelcome the the MBED LPC1768 Developers Module\n\r");
        pc.printf("Using the RS-EDP Development Platform hardware\n\r");
        pc.printf("Software Revision Number: %d\n\r\n", FIRMWARE_VERSION);
    

        /* mbed Setup */
        pc.printf("\nMbed Module setup...\n\r");
        pc.printf("    Setting up the CNTRL SPI for Master mode\n\r");
        setup_CNTRL_SPI_Master_Mode();                                                                /* SPI setup */
        pc.printf("    Setting up the CNTRL I2C for Master mode\n\r");    
        setup_CNTRL_I2C_Master_Mode();                                                                /* Main CNTRL I2C control channel */
        pc.printf("    Setting up the ASC0, UART0 Serial Channel\n\r");    
        setup_UART0();                                                                                /* Standard UART */
        pc.printf("    Setting up the ASC1, UART1 Serial Channel\n\r");    
        setup_UART1();                                                                                /* Additional UART */
        

        /* Base Board Configuration & setup */
        pc.printf("\nBase Board setup...\n\r");
        pc.printf("    Setting up the 24LC32 Serial EEPROM\n\r");                    
        RSEDP_BB_setup_24LC32(M24C32_BASE_BOARD);                                                    /* Setup the Serial EEPROM device on the base board */
        pc.printf("    Setting up the PCA9675 Serial Latch For reading the DIP Switches\n\r");                            
//        RSEDP_BB_setup_PCA9675(PCA9675_BASE_BOARD);                                                 /* Setup the Serial Latch on the base board */

        if (COMMS_MODULE_FITTED == YES)
            {
                /* Communications module Setup */
                pc.printf("\nCommunications Board setup...\n\r");
                pc.printf("    Setting up the serial PCF8583 Real Time Clock IC\n\r");
                RSEDP_COM_setup_PCF8583(PCF8583_COMMS_MODULE,'C');                                            /* Setup the Real Time Clock for Clock mode on the Comms Module */
            }

        if (DIGITAL_IO_MODULE_FITTED == YES)
            {
                /* Digital I/O module Setup */
                pc.printf("\nDigital I/O Module setup...\n\r");
                pc.printf("    Setting up the serial PCA9555 Digital Output Expander\n\r");
                RSEDP_DIO_setup_PCA9555(PCA9555_DIGITAL_IO_OUT, 0xff,0xff);                                    /* Setup the Serial digital output latch on the digital I/O board */        
                pc.printf("    Setting up the serial PCA9555 Digital Input Expander\n\r");                            /* setup the serial digital input latch */
                RSEDP_DIO_setup_PCA9555(PCA9555_DIGITAL_IO_IN, 0xff,0xff);                                    /* Setup the Serial I/O Expander on the digital I/O Board */    
            }
                
        if (ANALOGUE_MODULE_FITTED == YES)
            {
                /* Analogue Module setup */
                pc.printf("\nAnalogue Module setup...\n\r");
                pc.printf("    Setting up the ADC5263 serial Digital Potentiometer\n\r");                    /* Digital Pot used in the input filter */
                RSEDP_AM_Init_AD5263(AD5263_ANALOGUE_DIGITAL_POT);                                            
                pc.printf("    Setting up the MAX1x3x serial ADC\n\r");                                        /* Serial ADC Convter IC */
                RSEDP_AM_Init_MAX1x3x(MAX1X3X_ANALOGUE_ADC) ;
            }
        
        if (MOTOR_MC1_MODULE_FITTED == YES)
            {
                /* Brushed DC MC1 Module Drive Module setup */
                pc.printf("\nMC1 Brushed DC Motor Drive Module setup...\n\r");
                pc.printf("    Setting up the PWM\n\r");                                                    /* Set the PWM frequency */        
                RSEDP_MC1_Setup();
            }
        
        RSEDP_test_all();                                                                                    /* Run the test and diagnostic facility for the board */
        

        
        /* never get here */
        while(1)
            {
                ;
            }
    }
    

 
