/* This module is to drive the Serial Digital I/O PCA9555 Device */
/* ************************************************************* */


/* Version 1.00 */
/* Start Date: 23/6/09 */


/* The digital Output from the serial latch drive the ULN2003 line driver devices */
/* The digital input devices come through a protection circuit on the board and are then fed into the serial input latch */


/* Include Files Here */
#include "mbed.h"                                /* mbed header file */
#include "misra_types.h"                         /* MISRA Types header file */
#include "defines.h"
#include "RSEDP_Slave_Address_Defines.h"        /* Slave Address of CNTRL I2C devices */

#include "mbed_Port_Structure.h"                /* Port structure for MBED Module */
#include "RSEDP_CNTRL_I2C.h"                    /* Control I2C Driver */




/* Function Prototypes Here */
sint32_t RSEDP_DIO_setup_PCA9555(uint8_t Slave_Address, uint8_t Port0_IO_Direction,uint8_t Port1_IO_Direction);         /* Setup the device I/O Direction */
sint32_t RSEDP_DIO_PCA9555_Write_Word(uint8_t Slave_Address, uint8_t Port0_Payload, uint8_t Port1_Payload);              /* Write to the I/O pins */
sint32_t RSEDP_DIO_PCA9555_Read_Data(uint8_t Slave_Address, uint8_t *Port0_Data, uint8_t*Port1_Data);                    /* Read data on the input pins */

static sint32_t PCA9555_Write_Data(uint8_t Slave_Address, uint8_t command_byte, uint8_t P0_payload, uint8_t P1_payload);/* Local function used to xfer data to the I2C Module */



/* Setup the device I/O Direction of the Latch*/
sint32_t RSEDP_DIO_setup_PCA9555(uint8_t Slave_Address, uint8_t Port0_IO_Direction,uint8_t Port1_IO_Direction)
    {
        sint32_t Ack_Status = 0;
        /* Assume the I2C peripheral and I/O is already configured */

        Ack_Status = PCA9555_Write_Data(Slave_Address, 0x06, Port0_IO_Direction, Port1_IO_Direction);                            /* This 0x06 = configures the I/O direction */
        return Ack_Status;
    }    
    


/* Write Data Out to the Port Latches */
sint32_t RSEDP_DIO_PCA9555_Write_Word(uint8_t Slave_Address, uint8_t Port0_Payload, uint8_t Port1_Payload)
    {
        sint32_t Ack_Status = 0;
        
        Ack_Status = PCA9555_Write_Data(Slave_Address, 0x02, Port0_Payload, Port1_Payload);                                        /* This Writes the data to the I/O latches */
        return Ack_Status;
    }
    

/* Read the values on the serial latch pins */
sint32_t RSEDP_DIO_PCA9555_Read_Data(uint8_t Slave_Address, uint8_t *Port0_Data, uint8_t*Port1_Data)                                
    {
        sint32_t Ack_Status = 0;
        sint8_t rx_array[2] = {0x00, 0x00};                                            /* Local reception array */
        sint8_t tx_array[1] = {0x000};                                                /* Data to transmit */
        
        tx_array[0] = 0;                                                             /* Command Byte For Read */
        
        Ack_Status = CNTRL_I2C_Master_Mode_Transmit(Slave_Address, tx_array, 1);
        
        if (Ack_Status == ACK)
            {
                Ack_Status = CNTRL_I2C_Master_Mode_Receive(Slave_Address, rx_array, 2);            /* Receive two bytes from the serial latch */
                *Port0_Data = rx_array[0];                                                    /* Transfer Port 0 Data to pointer */
                *Port1_Data = rx_array[1];                                                  /* Transfer Port 1 Data to pointer */
            }
        return Ack_Status;
      }
    




/* Write address, command byte plus two additional bytes of data to the device */
static sint32_t PCA9555_Write_Data(uint8_t Slave_Address, uint8_t command_byte, uint8_t P0_payload, uint8_t P1_payload)
    {
        sint32_t Ack_Status = 0;
        sint8_t tx_array[3];                                                        /* Local array of data to be transmitted */
        
        tx_array[0] = command_byte;                                                    /* Load transmit array */
        tx_array[1] = P0_payload;                                                    /* First is for Port 0 */
        tx_array[2] = P1_payload;                                                       /* Second is for Port 1 */
        
        Ack_Status = CNTRL_I2C_Master_Mode_Transmit(Slave_Address, tx_array, 3);            /* Send 3 bytes */
        return Ack_Status;
    }

