/* RS-EDP CNTRL SPI Functions */
/* ************************** */


/* Includes Here */
#include "mbed.h"
#include "misra_types.h"				/* Standard Misra Types For ARM */

#include "mbed_Port_Structure.h"		/* mbed module port structure and port functions */



/* Function Prototpyes */
void setup_CNTRL_SPI_Master_Mode(void);
uint8_t CNTRL_SPI_Write_Byte(uint8_t data_byte);
uint8_t CNTRL_SPI_Read_Byte(void);


/* setup and configure the SPI Peripheral */
void setup_CNTRL_SPI_Master_Mode(void)
	{
		/* IO Structure already configures in mbed_Port_Structure.c */
		CNTRL_spi.format(8,3);									/* 8 bit, Clock Polarity, Clock Phase */
	    CNTRL_spi.frequency(1000000);								/* Clock frequency in Hertz */
	}
	
	



/* Send one byte of data out to the SPI */
uint8_t CNTRL_SPI_Write_Byte(uint8_t data_byte)
	{
		uint8_t return_value = 0;
		return_value = CNTRL_spi.write(data_byte);
		return return_value;
	}




/* Read one byte of data from the SPI */
uint8_t CNTRL_SPI_Read_Byte(void)
	{
		uint8_t return_value = 0;
		
		return_value = CNTRL_spi.write(0x00)	;				/* transmit a dummy byte */
		return return_value;									/* Return with read in value */
	}
	