/* I2C Handler Functions for MBED Module */
/* ************************************* */


/* Includes Here */
#include "mbed.h"
#include "misra_types.h"                /* Standard Misra Types For ARM */

#include "mbed_Port_Structure.h"        /* mbed module port structure and port functions */



/* Defines Here */




/* Variables Defined Here */



/* Function Prototypes Here */
void setup_CNTRL_I2C_Master_Mode(void);                                                                         /* Configuration & setup */
sint32_t CNTRL_I2C_Master_Mode_Transmit(uint8_t targ_address, sint8_t *Tx_Array, uint16_t num_bytes);            /* Send a data packet from this master to a slave device */
sint32_t CNTRL_I2C_Master_Mode_Receive(uint8_t targ_address, sint8_t *Rx_Array, uint16_t num_bytes);            /* Receive a data packet from a slave */




/* I2C0 Setup and configuration routine */
void setup_CNTRL_I2C_Master_Mode(void)
    {
        /* already setup the peripheral pins for SCL and SDA */
        CNTRL_i2c.frequency(400000);
    }




/* Send an I2C Write Packet to an I2C Slave Peripheral */
sint32_t CNTRL_I2C_Master_Mode_Transmit(uint8_t targ_address, sint8_t *Tx_Array, uint16_t num_bytes)
    {
         sint32_t Ack_Status = 0;
         targ_address = (targ_address << 1);
         Ack_Status = CNTRL_i2c.write(targ_address, Tx_Array, num_bytes);                                                 /* Send an I2C packet */
         return Ack_Status;
    }



/* Receive an I2C Packet in Master Mode from the slave to the bus */
sint32_t CNTRL_I2C_Master_Mode_Receive(uint8_t targ_address, sint8_t *Rx_Array, uint16_t num_bytes)
    {
       sint32_t Ack_Status = 0;
       
       targ_address = ((targ_address << 1) | 0x01);
       Ack_Status = CNTRL_i2c.read(targ_address, Rx_Array, num_bytes);
       return Ack_Status;
    }




