/* Software Driver for Serial Input Latch PCA9675 on the RS-EDP Base Board */
/* *********************************************************************** */



/* Version 1.00 */



/* Include Files */
/* Include Files Here */
#include "mbed.h"                                /* mbed header file */
#include "misra_types.h"                         /* MISRA Types header file */
#include "defines.h"
#include "RSEDP_Slave_Address_Defines.h"        /* Slave address of I2C Peripherals */

#include "mbed_Port_Structure.h"                /* Port structure for MBED Module */
#include "RSEDP_CNTRL_I2C.h"                    /* Control I2C Driver */



/* Function Prototypes Defines Here */
sint32_t RSEDP_BB_setup_PCA9675(uint8_t Slave_Address);                                                          /* Setup and configure the I/O latch */
sint32_t RSEDP_BB_PCA9675_reset(uint8_t Slave_Address);                                                          /* Reset the device using a general call */
sint32_t RSEDP_BB_PCA9675_write_data(uint8_t Slave_Address, uint8_t port0_payload,uint8_t port1_payload);        /* Write two bytes of data to the device */
sint32_t RSEDP_BB_PCA9675_read_data(uint8_t Slave_Address, uint8_t *read_port0, uint8_t *read_port1);            /* Read two bytes from the device */
sint32_t RS_EDP_BB_Read_DIP_Switch(uint8_t Switch_Number);                                                       /* Read the switch position - either on or off */





/* Configure the Serial I/O Expander IC */
sint32_t RSEDP_BB_setup_PCA9675(uint8_t Slave_Address)
    {
       sint32_t Ack_Status = 0;
        /* Assume the I2C peripheral and MCU I/O is already configured */

        Ack_Status = RSEDP_BB_PCA9675_reset(Slave_Address);                                              /* Reset the device */
        if (Ack_Status == ACK)
            {
                Ack_Status = RSEDP_BB_PCA9675_write_data(Slave_Address, 0xff,0xff);                                /* This configures all I/O as input */
            }
        return Ack_Status;
    }    
    
    

/* Reset the device */                
sint32_t RSEDP_BB_PCA9675_reset(uint8_t Slave_Address)
    {
        sint32_t Ack_Status = 0;
        sint8_t reset_command = 0x06;                                                   /* Reset command following a general call, address 0 will reset the device */

        Ack_Status = CNTRL_I2C_Master_Mode_Transmit(0x0, &reset_command, 2);            /* Send a general call command, (Slave address 0), plus one byte of value 0x06 */
                                                                                        /* The PCA9675 does not generate an ACK on a general call */
        return Ack_Status;                                                                                        
    }                                    


/* Write two byte of data to the device */
sint32_t RSEDP_BB_PCA9675_write_data(uint8_t Slave_Address, uint8_t port0_payload, uint8_t port1_payload)
    {
        sint32_t Ack_Status = 0;
        sint8_t tx_array[2];                                                        /* Local array of data to be transmitted */
        
        tx_array[0] = port0_payload;                                                /* First is for Port 0 */
        tx_array[1] = port1_payload;                                                /* Second is for Port 1 */
        
        Ack_Status = CNTRL_I2C_Master_Mode_Transmit(Slave_Address, tx_array, 2);    /* Send two bytes plus the slave address to the slave */
        return Ack_Status;
    }


/* Read two bytes from the device */
sint32_t RSEDP_BB_PCA9675_read_data(uint8_t Slave_Address, uint8_t *read_port0, uint8_t *read_port1)
    {
        sint32_t Ack_Status = 0;
        sint8_t rx_array[2];                                                      /* Local reception array */

        Ack_Status = CNTRL_I2C_Master_Mode_Receive(Slave_Address, rx_array, 2);   /* Receive two bytes */
        *read_port0=rx_array[0];                                                  /* transfer data back to pointer */
        *read_port1=rx_array[1];                                                  /* transfer data back to pointer */
        return Ack_Status;
    }        


/* Read the switch position - either on or off */
sint32_t RS_EDP_BB_Read_DIP_Switch(uint8_t Switch_Number, uint8_t *Switch_Status)
    {
        sint32_t Ack_Status = 0;
        uint8_t port0 = 0;                                                        
        uint8_t port1 = 0;
        
        Ack_Status = RSEDP_BB_PCA9675_read_data(PCA9675_BASE_BOARD, &port0, &port1);
        
        switch (Switch_Number)
            {
        
            case 1:
                if ((port0 & 0x01) == SWITCH_ON) 
                    {
                        *Switch_Status = DIP_SWITCH_CLOSED;
                    }
                else{
                        *Switch_Status = DIP_SWITCH_OPEN;
                    }
                break;

            case 2:
                if ((port0 & 0x02) == SWITCH_ON)
                    {
                        *Switch_Status = DIP_SWITCH_CLOSED;
                    }
                else{
                        *Switch_Status = DIP_SWITCH_OPEN;
                    }
                break;
                                
            case 3:
                if ((port0 & 0x04) == SWITCH_ON)
                    {
                        *Switch_Status = DIP_SWITCH_CLOSED;
                    }
                else{
                        *Switch_Status = DIP_SWITCH_OPEN;
                    }
                break;
                        
            case 4:
                if ((port0 & 0x08) == SWITCH_ON)
                    {
                        *Switch_Status = DIP_SWITCH_CLOSED;
                    }
                else{
                        *Switch_Status = DIP_SWITCH_OPEN;
                    }
                break;
                
            case 5:
                if ((port0 & 0x10) == SWITCH_ON)
                    {
                        *Switch_Status = DIP_SWITCH_CLOSED;
                    }
                else{
                        *Switch_Status = DIP_SWITCH_OPEN;
                    }
                break;
                
            case 6:
                if ((port0 & 0x20) == SWITCH_ON)
                    {
                        *Switch_Status = DIP_SWITCH_CLOSED;
                    }
                else{
                        *Switch_Status = DIP_SWITCH_OPEN;
                    }
                break;
                
            case 7:
                if ((port0 & 0x40) == SWITCH_ON) 
                    {
                        *Switch_Status = DIP_SWITCH_CLOSED;
                    }
                else{
                        *Switch_Status = DIP_SWITCH_OPEN;
                    }
                break;
                
            case 8:
                if ((port0 & 0x80) == SWITCH_ON) 
                    {
                        *Switch_Status = DIP_SWITCH_CLOSED;
                    }
                else{
                        *Switch_Status = DIP_SWITCH_OPEN;
                    }
                break;
                
            default:
                    {
                        *Switch_Status = port0;
                    }
            }        
        return Ack_Status;
     }
    