/* ASC0/UART0 Configuration for RS-EDP Board */
/* ***************************************** */

/* Configure ASC0/UART0 for General Purpose UART, using mbed libraries */


/* Includes Here */
#include "mbed.h"
#include "misra_types.h"                /* Standard Misra Types For ARM */
#include "mbed_Port_Structure.h"        /* mbed module port structure and port functions */



/* function Prototypes Defined Here */
void setup_UART0(void);
uint16_t UART0_Receieve_Byte(void);




/* Setup UART0 */
void setup_UART0(void)                                                                 /* Configure UART0 */
    {

        /*
             UART0 configured as follow:
             - Word Length = 8 Bits
             - One Stop Bit
             - No parity
             - BaudRate = 115200 baud
             - Hardware flow control disabled (no RTS nor CTS signals)
             - Receive and transmit enabled
        */
  
              UART0.baud(115000);
              UART0.format(8,Serial::None,1);

    }



/* UART0 Receieve Routine */
uint16_t UART0_Receieve_Byte(void)
    {
        return 0;
    }


