/* Defines */


/* Software Revision Number */
#define FIRMWARE_VERSION 3

/* Module Inclusion */
#define YES 1
#define NO 0
#define ANALOGUE_MODULE_FITTED      YES
#define DIGITAL_IO_MODULE_FITTED    YES
#define COMMS_MODULE_FITTED         YES
#define MOTOR_MC1_MODULE_FITTED     YES
#define MOTOR_MC2_MODULE_FITTED     YES



/* LED On/OFF Defines */
#define LED_ON 1
#define LED_OFF 0


/* DIP SWITCH on the base board defines */
#define DIP_SWITCH_CLOSED 1                            /* This is the value you return when the DIP switch is in the closed position */
#define DIP_SWITCH_OPEN 0                            /* This is the value you return when the DIP switch is in the open position */
#define SWITCH_ON 0                                    /* This is the logic level you see when the DIP switch is closed (a short to ground produces a logic zero on the pin) */
#define SWITCH_OFF 1                                /* This is the logic level you see when the DIP switch is open (a pull up to Vcc produces a logic one on the pin) */
#define ALL_DIP_SWITCHES 10                            /* This is the value used when you need to read all of the switches */

/* I2C Defines */
#define ACK 0


/* Motor Drive MC2 Module Defines */
/* This block of 3 pairs of defines relates to the FLAGS used in the Flags structure */
#define CLOCKWISE 1u
#define COUNTER_CLOCKWISE 0u

#define FAULT_PRESENT 0u
#define NO_FAULT_PRESENT 1u

/* Machine States for I2C Control of the Motor Drive module MC2 */
#define STOPPED 0u															/* Motor is STOPPED */
#define STOPPING 1u															/* Motor is decelerating towards the stop */
#define NEW_MOTOR_DEMAND_FORWARD 2u											/* New demand speed receieved for the forward direction */
#define NEW_MOTOR_DEMAND_REVERSE 3u											/* New demand speed receieved for the reverse direction */
#define NORMAL_RUNNING 4u													/* Motor is running normally and has achieved target speed */
#define ROTATE_X_QUAD_COUNTS 5u												/* The PMSM has receieved a rotate quad counts command and is running through this count sequence */
#define LAST_REVOLUTION 6u													/* The motor is going through its final approach sequence, and is usually in its last revolution before stopping */
#define GOTO_HOME 7u														/* the motor is trying to find its home sensor, so it can reference itself */

#define MOTOR_RUNNING 1u
#define MOTOR_STOPPED 0u



/* Analogue module */
#define ADC_8BIT     8
#define ADC_10BIT     10
#define ADC_BITSIZE     ADC_8BIT                    /* change this line to accomodate ADC size - two settings either ADC_8BIT or ADC_10BIT */

/* AD5623 Digital Potentiometer Commands */
/* These are used in the instruction byte */
#define AD5263_RDAC_A1            0x40
#define AD5263_RDAC_A0            0x20
#define AD5263_RDAC_Ch1            0x00
#define AD5263_RDAC_Ch2            0x20
#define AD5263_RDAC_Ch3            0x40
#define AD5263_RDAC_Ch4            0x60

#define AD5263_RDAC_Midscale_Reset  0x10
#define AD5263_RDAC_Shutdown        0x08

#define AD5263_RDAC_O2_UserBit        0x04
#define AD5263_RDAC_O1_UserBit        0x02

#define AD5263_No_Of_Channels        4

/* Potentiometer Characteristics */
#define AD5263_Max_Resistance    50000                  /* 50kOhms */
#define AD5263_Resolution        256    

#define AD5263_RDAC1_Default_Resistance 6800
#define AD5263_RDAC2_Default_Resistance 12000
    
#define AD5263_RDAC3_Default_Resistance 6800
#define AD5263_RDAC4_Default_Resistance 12000
    




/* MAX1038 ADC Register Bit Definitions */
/* Definitions For SETUP Byte */
#define MAX1x3x_SETUP_NO_RST     0x02
#define MAX1x3x_SETUP_RST        0x00
#define MAX1x3x_SETUP_BiPol      0x04
#define MAX1x3x_SETUP_UniPol     0x00
#define MAX1x3x_SETUP_ExtCLK     0x08
#define MAX1x3x_SETUP_IntCLK     0x00
#define MAX1x3x_SETUP_SEL0       0x10
#define MAX1x3x_SETUP_SEL1       0x20
#define MAX1x3x_SETUP_SEL2       0x40
#define MAX1x3x_SETUP_REG         0x80                                      /* 0x80 MSB =1 means this is a Setup byte */

#define MAX1x3x_SETUP_SEL_EXT_Ref_AN11_AlwaysOff        (0x2<<4)
#define MAX1x3x_SETUP_SEL_INT_Ref_AN11RefIn_AutoSHD     (0x4<<4)
#define MAX1x3x_SETUP_SEL_INT_Ref_AN11_AlwaysOn            (0x5<<4)
#define MAX1x3x_SETUP_SEL_INT_Ref_AN11RefOut_AlwaysOn    (0x6<<4)

/* Definition For CONFIG Byte */
#define MAX1x3x_CONFIG_SingleEnded    0x01
#define MAX1x3x_CONFIG_CS0           0x02
#define MAX1x3x_CONFIG_CS1           0x04
#define MAX1x3x_CONFIG_CS2           0x08
#define MAX1x3x_CONFIG_CS3           0x10
#define MAX1x3x_CONFIG_SCAN0         0x20
#define MAX1x3x_CONFIG_SCAN1         0x40
#define MAX1x3x_CONFIG_REG             0x00                                  /* 0x00 MSB = 0 means this is a Config byte */

#define MAX1x3x_CONFIG_SingleChannel_x8       (0x01<<5)
#define MAX1x3x_CONFIG_SingleChannel          (0x03<<5)

#define MAX1x3x_CONFIG_ConvCh0                0x00
#define MAX1x3x_CONFIG_ConvCh1                (0x01<<1)
#define MAX1x3x_CONFIG_ConvCh2                (0x02<<1)
#define MAX1x3x_CONFIG_ConvCh3                (0x03<<1)
#define MAX1x3x_CONFIG_ConvCh4                (0x04<<1)
#define MAX1x3x_CONFIG_ConvCh5                (0x05<<1)
#define MAX1x3x_CONFIG_ConvCh6                (0x06<<1)
#define MAX1x3x_CONFIG_ConvCh7                (0x07<<1)
#define MAX1x3x_CONFIG_ConvCh8                (0x08<<1)
#define MAX1x3x_CONFIG_ConvCh9                (0x09<<1)
#define MAX1x3x_CONFIG_ConvCh10                (0x0A<<1)
#define MAX1x3x_CONFIG_ConvCh11                (0x0B<<1)

#define MAX1x3x_No_Of_Channels              12 




/* MC1 motor Control I/O Module Defines */
#define AN0        0
#define AN2     2
#define AN4        4
#define AN10    10
#define AN12     12
#define AN14    14

#define EVM5_GPIO47 0                                            /* used for Encoder0 and Tacho Pulse inputs */
#define EVG6_GPIO52 1

#define EVM6_GPIO49 0                                            /* used for Encoder1 input */
#define EVG7_GPIO54 1

#define EVM4_GPIO45    0                                            /* Used for reading motor direction */
#define EVG16_GPIO64 1

#define EVG1_GPIO42    0                                            /* Used for writing motor direction */
#define EVG5_GPIO50 1

#define EVG0_GPIO40 0                                            /* Used for PWM speed duty cycle */
#define EVG4_GPIO48 1

#define GPIO0 0                                                    /* Used for motor brake signal */
#define GPIO1 1

#define FORWARD 0
#define REVERSE 1

#define BRAKE_ON 1
#define BRAKE_OFF 0

#define CURRENT_TRANSFER_RATIO 6.0E-04f                            /* The LMD18200 has a 400uA per ampere CTR .ie 1A of motor current produces 400uA of current sense */
#define MOTOR_CURRENT_SENSE_RESISTOR 2.2e03f                    /* Value in ohms */

#define VSENSE_DIVISOR 0.248f                                    /* R207 / (R207+R205) */




/* Test Module */
#define EEPROM_TEST_BYTE 0x3c
    

