/* Header file for MC1 Motor Drive module */
/* ************************************** */


/* Setup the MC1 Board */
extern void RSEDP_MC1_Setup(void);                                        


/* Analogue Levels */
extern uint16_t RSEDP_MC1_Read_VDCLINK(uint8_t channel);                /* Read the filtered 12V DC voltage on the MC1 board via pot down resistors */
extern uint16_t RSEDP_MC1_Read_VSENSE(uint8_t channel);                 /* Read the filtered current sense output from the MC1 board */


/* Digital level inputs */
extern uint8_t RSEDP_MC1_Read_Encoder0_Input(uint8_t pin_option);        /* Read the physical level on the Encoder0 input pin on P301 pin 8 on the MC1 board*/
extern uint8_t RSEDP_MC1_Read_Encoder1_Input(uint8_t pin_option);        /* Read the physical level on the Encoder1 input pin on P301 pin 10 on the MC1 board*/
extern uint8_t RSEDP_MC1_Read_Tacho_Input(uint8_t pin_option);           /* Read the physical level on the Tacho Pulses Input pin on P301 pin 6 on the MC1 board */


/* Outputs */
extern void RSEDP_MC1_Set_Motor_Direction(uint8_t motor_direction, uint8_t pin_option);            /* Set the motor direction */
extern void RSEDP_MC1_Brake(uint8_t brake_onoff, uint8_t pin_option);                              /* turn the brake on or off */
extern void RSEDP_MC1_Set_Motor_Speed_Duty(float motor_speed_duty, uint8_t pin_option);            /* Power control of motor speed controller using PWM */

